/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners;

import de.rtb.pcon.features.partners.PartnerConfigurationService;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import java.util.Set;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class PaymentForeignRetisterService {
    public static final Set<PaymentReason> ALLOWED_PAYMENT_REASONS = Set.of(PaymentReason.PURCHASE, PaymentReason.JETON, PaymentReason.ZERO_TICKET);
    @Autowired
    private PartnerConfigurationService partnerConfigService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="taskExecutorAsync")
    private Executor executor;

    public void registerPayment(PaymentTransaction pt) {
        if (!ALLOWED_PAYMENT_REASONS.contains(pt.getPaymentReason())) {
            return;
        }
        this.partnerConfigService.fetchTransportConfig(pt.getId().getPdm().getZone().getArea()).stream().map(cfg -> cfg.createPaymentRegistrationTask(pt, this.applicationContext)).forEach(t -> this.executor.execute((Runnable)t));
    }
}

