/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.events.PartnerDeletedEvent;
import de.rtb.pcon.core.events.PartnerUpdatedEvent;
import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.PartnerConfigurationService;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaPartnerType;
import de.rtb.pcon.repositories.AreaPartnerRepository;
import org.jspecify.annotations.NullMarked;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@NullMarked
public abstract class PartnesConfigurationServiceBase<T extends PartnerConfiguration> {
    protected final AreaPartnerRepository configRepo;
    protected final ObjectMapper objectMapper;
    protected final AreaPartnerType partnerType;
    @Autowired
    private PartnerConfigurationService partnerConfigService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    protected PartnesConfigurationServiceBase(AreaPartnerType partnerType, AreaPartnerRepository configRepo, ObjectMapper objectMapper) {
        this.partnerType = partnerType;
        this.configRepo = configRepo;
        this.objectMapper = objectMapper;
    }

    public T fetchConfig(Area area) {
        PartnerConfiguration cfg = (PartnerConfiguration)this.partnerConfigService.fetchConfigs(area).get(this.partnerType);
        if (cfg != null) {
            return (T)cfg;
        }
        return (T)this.newDefautlConfig();
    }

    public void updateConfig(Area area, T config) {
        this.partnerConfigService.updateConfig(area, config, this.partnerType);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)PartnerUpdatedEvent.updateOnePartner((Object)this, (Integer)area.getId(), (AreaPartnerType)this.partnerType));
    }

    public void deleteConfig(Area area, AreaPartnerType partnerType) {
        this.partnerConfigService.deleteConfig(area, partnerType);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)PartnerDeletedEvent.deleteOnePartner((Object)this, (Integer)area.getId(), (AreaPartnerType)partnerType));
    }

    public abstract T newDefautlConfig();
}

