/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_2;

import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleEntity;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleRepository;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2UsageEntity;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2UsageRepository;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.Zone;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
class BonMt2Service {
    private static final Logger log = LoggerFactory.getLogger(BonMt2Service.class);
    @Autowired
    private BonMt2RuleRepository ruleRepo;
    @Autowired
    private BonMt2UsageRepository usageRepo;

    BonMt2Service() {
    }

    @Transactional(readOnly=true)
    public Optional<BonMt2RuleEntity> findRule(String lpn, Zone zone) {
        return this.ruleRepo.findByLpnAndZone(lpn, zone);
    }

    @Transactional(readOnly=true)
    public Optional<BonMt2RuleEntity> findRule(String lpn, Pdm pdm) {
        return this.ruleRepo.findByLpnAndZone(lpn, pdm.getZone());
    }

    @Transactional
    public void upsertRule(BonMt2RuleEntity rule) {
        this.ruleRepo.insertOrUpdate(rule.getLpn(), rule.getValidFrom(), rule.getValidTo(), rule.getTariffName(), rule.getExpiryToleranceInDays(), rule.getZone().getId());
    }

    @Transactional(readOnly=true)
    public Optional<BonMt2UsageEntity> usedToday(String lpn, Pdm pdm) {
        OffsetDateTime midnight = ZonedDateTime.now(ZoneId.of(pdm.getZone().getArea().getTimeZoneName())).truncatedTo(ChronoUnit.DAYS).toOffsetDateTime();
        return this.usageRepo.findTop1ByLpnAndPdmZoneAndUsedAfter(lpn, pdm.getZone(), midnight);
    }

    @Transactional
    public void recordUsage(String lpn, Pdm pdm, OffsetDateTime usedAt) {
        BonMt2UsageEntity usage = new BonMt2UsageEntity();
        usage.setLpn(lpn);
        usage.setPdm(pdm);
        usage.setUsed(usedAt);
        this.usageRepo.save((Object)usage);
    }

    @Scheduled(cron="0 16 3 * * SAT")
    @Transactional
    public void deleteOldRecords() {
        log.info("Running clean up of 'multi tariff 2'.");
        int deletedRules = this.ruleRepo.deleteExpiredEntries();
        int deletedUsages = this.usageRepo.deleteByUsedBefore(OffsetDateTime.now().minusDays(30L));
        log.info("Cleaned up bonus 'multi tariff 2'. Deleted {} rules and {} usages.", (Object)deletedRules, (Object)deletedUsages);
    }

    public Stream<BonMt2RuleEntity> streamRules(Zone zone) {
        return this.ruleRepo.streamByZoneOrderByLpn(zone);
    }

    public void deleteRules(Zone zone) {
        this.ruleRepo.deleteByZone(zone);
    }

    Page<BonMt2RuleEntity> findByZone(Zone zone, Pageable pageable) {
        return this.ruleRepo.findByZone(zone, pageable);
    }
}

