/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_2;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2Service;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.time.OffsetDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BonMt2RtrUse
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(BonMt2RtrUse.class);
    @Autowired
    private BonMt2Service mt2Service;

    BonMt2RtrUse() {
    }

    public int getId() {
        return 26;
    }

    public String getDescription() {
        return "Multi tariff 2, use";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Pdm pdm = ctx.findPdmEntity();
        String lcn = ctx.getLicensePlate();
        OffsetDateTime timestamp = ctx.global().getDatTim();
        if (pdm.getZone() == null && log.isWarnEnabled()) {
            log.warn("{} should not record bonus usage, because it does not belong to any zone.", (Object)StringUtils.capitalize((String)LoggerUtils.log((Pdm)pdm)));
        }
        this.mt2Service.recordUsage(lcn, pdm, timestamp);
        if (log.isDebugEnabled()) {
            log.debug("Recoded usage for '{}' by {}.", (Object)lcn, (Object)LoggerUtils.log((Pdm)pdm));
        }
        return Map.of();
    }
}

