/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_2;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleDao;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleEntity;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2Service;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BonMt2RtrExtend
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(BonMt2RtrExtend.class);
    @Autowired
    private BonMt2Service mt2Service;

    BonMt2RtrExtend() {
    }

    public int getId() {
        return 27;
    }

    public String getDescription() {
        return "Multi tariff 2, extend";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Pdm pdm = ctx.findPdmEntity();
        String lcn = ctx.getLicensePlate();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (pdm.getZone() == null) {
            if (log.isWarnEnabled()) {
                log.warn("Extension is not possible because {} does not belong to any zone.", (Object)LoggerUtils.log((Pdm)pdm));
            }
            result.put("ERC", 5);
            return result;
        }
        Optional ruleO = this.mt2Service.findRule(lcn, pdm);
        if (ruleO.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn("Bonus for '{}' does not exist in {}. Extension is not possible.", (Object)lcn, (Object)LoggerUtils.log((Zone)pdm.getZone()));
            }
            return result;
        }
        ZoneId pdmZoneId = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
        OffsetDateTime newTo = ZonedDateTime.of(LocalDateTime.parse(ctx.getLocalString("to")), pdmZoneId).toOffsetDateTime();
        BonMt2RuleEntity rule = (BonMt2RuleEntity)ruleO.get();
        rule.setValidTo(newTo);
        if (log.isDebugEnabled()) {
            log.debug("Bonus for '{}' in {} was extended to {}.", new Object[]{lcn, LoggerUtils.log((Zone)pdm.getZone()), rule.getValidTo()});
        }
        result.put("subscription", new BonMt2RuleDao(rule, pdmZoneId));
        return result;
    }
}

