/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.gates;

import de.rtb.pcon.features.bonus.gates.PresentTicketEntity;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;

record UiActiveTicket(Integer id, String ticketNumber, LocalDateTime arrival, LocalDateTime validFrom, LocalDateTime validTo, Boolean expired, String type, String data, List<String> flagsAllowed, List<String> flagsEnabled) {
    private final Integer id;
    private final String ticketNumber;
    private final LocalDateTime arrival;
    private final LocalDateTime validFrom;
    private final LocalDateTime validTo;
    private final Boolean expired;
    private final String type;
    private final String data;
    private final List<String> flagsAllowed;
    private final List<String> flagsEnabled;

    UiActiveTicket(Integer id, String ticketNumber, LocalDateTime arrival, LocalDateTime validFrom, LocalDateTime validTo, Boolean expired, String type, String data, List<String> flagsAllowed, List<String> flagsEnabled) {
        this.id = id;
        this.ticketNumber = ticketNumber;
        this.arrival = arrival;
        this.validFrom = validFrom;
        this.validTo = validTo;
        this.expired = expired;
        this.type = type;
        this.data = data;
        this.flagsAllowed = flagsAllowed;
        this.flagsEnabled = flagsEnabled;
    }

    public static UiActiveTicket fromEntity(PresentTicketEntity entity, ZoneId timeZone) {
        Boolean isExpired = Optional.ofNullable(entity.getValidTo()).map(to -> OffsetDateTime.now().isAfter((OffsetDateTime)to)).orElse(false);
        return new UiActiveTicket(entity.getId(), entity.getTicketNumber(), DateTimeUtils.toLocalDateTime((OffsetDateTime)entity.getArrival(), (ZoneId)timeZone), DateTimeUtils.toLocalDateTime((OffsetDateTime)entity.getValidFrom(), (ZoneId)timeZone), DateTimeUtils.toLocalDateTime((OffsetDateTime)entity.getValidTo(), (ZoneId)timeZone), isExpired, entity.getType(), entity.getData(), entity.getFlagsAllowed(), entity.getFlagsEnabled());
    }

    public Integer id() {
        return this.id;
    }

    public String ticketNumber() {
        return this.ticketNumber;
    }

    public LocalDateTime arrival() {
        return this.arrival;
    }

    public LocalDateTime validFrom() {
        return this.validFrom;
    }

    public LocalDateTime validTo() {
        return this.validTo;
    }

    public Boolean expired() {
        return this.expired;
    }

    public String type() {
        return this.type;
    }

    public String data() {
        return this.data;
    }

    public List<String> flagsAllowed() {
        return this.flagsAllowed;
    }

    public List<String> flagsEnabled() {
        return this.flagsEnabled;
    }
}

