/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.gates;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.integration.PdmMessageProcessingException;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.gates.PresentTicketEntity;
import de.rtb.pcon.features.bonus.gates.PresentTicketPdmDto;
import de.rtb.pcon.features.bonus.gates.PresentTicketRepository;
import de.rtb.pcon.model.zone.Zone;
import java.time.ZoneId;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class BonGateRtrList
implements RealTimeRequest {
    @Autowired
    private PresentTicketRepository repo;
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper pdmObjectMapper;

    BonGateRtrList() {
    }

    public int getId() {
        return 37;
    }

    public String getDescription() {
        return "Gate, list tickets";
    }

    @Transactional
    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Zone zone = ctx.global().getPdm().getZone();
        if (zone == null) {
            throw new PdmMessageProcessingException("PDM must be in zone.");
        }
        Integer pageSize = ctx.getLocalIntegerO("pLen").orElse(5);
        Integer pageNr = ctx.getLocalIntegerO("pNr").orElse(0);
        PageRequest page = PageRequest.of((int)pageNr, (int)pageSize);
        Slice tickets = this.repo.findByZoneOrderByTicketNumber(zone, (Pageable)page);
        return Map.of("tic", tickets.get().map(t -> PresentTicketPdmDto.fromEntity((PresentTicketEntity)t, (ZoneId)ctx.global().getTimeZone(), (ObjectMapper)this.pdmObjectMapper)).toList(), "next", tickets.hasNext());
    }
}

