/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.disposable;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.BonusUtils;
import de.rtb.pcon.features.bonus.disposable.BonDisRuleEntity;
import de.rtb.pcon.features.bonus.disposable.BonDisService;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BonDisRtrOffer
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(BonDisRtrOffer.class);
    @Autowired
    private BonDisService bonusService;

    BonDisRtrOffer() {
    }

    public int getId() {
        return 10;
    }

    public String getDescription() {
        return "Disposable bonus request";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Pdm pdm = ctx.findPdmEntity();
        String spc = ctx.getLocalString("SPC");
        if (ctx.findPdmEntity().getZone() == null && log.isErrorEnabled()) {
            log.error("The {} doesn't belong to any zone; therefore it is not possible to check bonus.", (Object)LoggerUtils.log((Pdm)pdm));
        }
        Optional bonusOpt = this.bonusService.offer(spc, pdm.getZone());
        HashedMap result = new HashedMap();
        if (bonusOpt.isPresent()) {
            BonDisRuleEntity b = (BonDisRuleEntity)bonusOpt.get();
            if (b.getDuration() != null && !b.getDuration().isZero()) {
                result.put((Object)"BOT", (Object)((int)b.getDuration().toMinutes()));
            }
            if (b.getDiscount() != null && b.getDiscount().compareTo(BigDecimal.ZERO) != 0) {
                result.put((Object)"BOA", (Object)b.getDiscount().scaleByPowerOfTen(ctx.getMonetaryScale()));
            }
            if (b.getTariff() != null) {
                Integer tariffIndex = BonusUtils.findTariffIndexByTariffName((String)b.getTariff(), (Pdm)pdm);
                result.put((Object)"TID", (Object)tariffIndex);
            }
        }
        return result;
    }
}

