/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.counter1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.counter1.BonCounter1DaoCounter;
import de.rtb.pcon.features.bonus.counter1.BonCounter1DaoPdmCounter;
import de.rtb.pcon.features.bonus.counter1.BonCounter1DaoPdmIncrement;
import de.rtb.pcon.features.bonus.counter1.BonCounter1Service;
import de.rtb.pcon.model.Pdm;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
class BonCounter1RtrIncrement
implements RealTimeRequest {
    private static final String COUNTERS_KEY = "counters";
    @Autowired
    private BonCounter1Service bonusService;
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper objectMapper;
    private Optional<TypeReference<List<BonCounter1DaoPdmIncrement>>> jacksonTypeReference = Optional.empty();

    BonCounter1RtrIncrement() {
    }

    public int getId() {
        return 29;
    }

    public String getDescription() {
        return "Counting bonus, increment";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        List incRequest = (List)ctx.getLocalObject(COUNTERS_KEY, this.getJacksonTypeReference());
        Pdm pdm = ctx.findPdmEntity();
        if (pdm.getZone() == null) {
            return Map.of("ERC", 5);
        }
        List<BonCounter1DaoPdmCounter> newCounterValues = incRequest.stream().map(inc -> {
            BonCounter1DaoCounter updatedCounter = this.bonusService.incrementeCounterValue(inc.getName(), inc.getIncrement().intValue(), pdm.getZone());
            return new BonCounter1DaoPdmCounter(updatedCounter);
        }).toList();
        return Map.of(COUNTERS_KEY, newCounterValues);
    }

    private TypeReference<List<BonCounter1DaoPdmIncrement>> getJacksonTypeReference() {
        return this.jacksonTypeReference.orElseGet(() -> new /* Unavailable Anonymous Inner Class!! */);
    }
}

