/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.basic_2;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.basic_2.BonBasic2Service;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BonBasic2RtrOffer
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(BonBasic2RtrOffer.class);
    @Autowired
    private BonBasic2Service individualBonsuService;

    BonBasic2RtrOffer() {
    }

    public int getId() {
        return 20;
    }

    public String getDescription() {
        return "LPN Individual bonus, provide";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String lcn = ctx.getLicensePlate();
        if (StringUtils.isBlank((CharSequence)lcn)) {
            log.error("Bonus cannot be provided because license plate number is not unknown.");
            return result;
        }
        this.individualBonsuService.findBonusValue(ctx.findPdmEntity(), lcn).ifPresent(bc -> {
            if (!bc.getDuration().isZero()) {
                result.put("BOT", bc.getDuration().toMinutes());
            }
            if (BigDecimal.ZERO.compareTo(bc.getPrice()) != 0) {
                result.put("BOA", bc.getPrice().scaleByPowerOfTen(ctx.getMonetaryScale()));
            }
        });
        return result;
    }
}

