/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus;

import de.rtb.pcon.db.converter.MinuteDurationConverter;
import de.rtb.pcon.features.bonus.AppliedBonusKind;
import de.rtb.pcon.features.bonus.AppliedBonusSource;
import de.rtb.pcon.model.PaymentTransaction;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.Duration;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@Entity
@Table(name="payment_bonus", schema="control")
public class AppliedBonus {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Integer id;
    @Convert(converter=MinuteDurationConverter.class)
    @Column(name="duration")
    private Duration duration;
    @Column(name="price")
    private BigDecimal price;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="pay_pdm_id", referencedColumnName="pdm_id"), @JoinColumn(name="pay_ts", referencedColumnName="pay_ts"), @JoinColumn(name="pay_trc", referencedColumnName="tracer")})
    private PaymentTransaction payment;
    @Column(name="origin", columnDefinition="\"control\".\"applied_bonus_origin\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private AppliedBonusSource source;
    @Column(name="kind", columnDefinition="\"control\".\"applied_bonus_kind\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private AppliedBonusKind kind;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration time) {
        this.duration = time;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal amount) {
        this.price = amount;
    }

    public PaymentTransaction getPayment() {
        return this.payment;
    }

    public void setPayment(PaymentTransaction payment) {
        this.payment = payment;
    }

    public AppliedBonusSource getSource() {
        return this.source;
    }

    public void setSource(AppliedBonusSource source) {
        this.source = source;
    }

    public AppliedBonusKind getKind() {
        return this.kind;
    }

    public void setKind(AppliedBonusKind kind) {
        this.kind = kind;
    }
}

