/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.user_data;

import de.rtb.pcon.core.user_data.UiUserDataFileGroup;
import de.rtb.pcon.core.user_data.UserDataFileEntity;
import de.rtb.pcon.core.user_data.UserDataFileRepositoty;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/pcon/ui/pdms/"})
class UserDataController {
    private static final Logger log = LoggerFactory.getLogger(UserDataController.class);
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private I18nService i18n;
    @Autowired
    private UserDataFileRepositoty userDataFileRepo;

    UserDataController() {
    }

    @GetMapping(path={"{pdmId}/user-files"})
    @Transactional
    public List<UiUserDataFileGroup> listFiles(@PathVariable(value="pdmId") int pdmId) {
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        return this.userDataFileRepo.findByPdm(pdm).stream().collect(Collectors.groupingBy(UserDataFileEntity::getGroup)).entrySet().stream().map(en -> new UiUserDataFileGroup((String)en.getKey(), (List)en.getValue(), timeZone)).sorted(Comparator.comparing(UiUserDataFileGroup::getGroup)).toList();
    }

    @GetMapping(path={"user-files/{id}"})
    @Transactional(readOnly=false)
    public void download(@PathVariable(value="id") int fileId, HttpServletResponse response) {
        UserDataFileEntity userFile = (UserDataFileEntity)this.userDataFileRepo.findById((Object)fileId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        if (this.securityService.deniedFor(userFile.getPdm())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        response.setContentType(userFile.getContentType());
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Date", ZonedDateTime.now(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME));
        response.setHeader("Content-Disposition", "attachment; filename=" + userFile.getName());
        try {
            IOUtils.copy((InputStream)userFile.getData().getBinaryStream(), (OutputStream)response.getOutputStream());
        }
        catch (IOException | SQLException e) {
            log.error("Can not copy user data to HTTP response", (Throwable)e);
        }
    }

    @DeleteMapping(path={"user-files/{id}"})
    @Transactional
    public void delete(@PathVariable(value="id") int fileId) {
        UserDataFileEntity userFile = (UserDataFileEntity)this.userDataFileRepo.findById((Object)fileId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        if (this.securityService.deniedFor(userFile.getPdm())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (userFile.getData() != null) {
            this.userDataFileRepo.unlinkDataObject(userFile.getId().intValue());
        }
        this.userDataFileRepo.delete((Object)userFile);
        log.info("User file {}/{} (#{}) deleted.", new Object[]{userFile.getGroup(), userFile.getName(), userFile.getId()});
    }

    @PostMapping(path={"user-files/{id}/abort"})
    @Transactional
    public void abort(@PathVariable(value="id") int fileId) {
        UserDataFileEntity userFile = (UserDataFileEntity)this.userDataFileRepo.findById((Object)fileId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        if (this.securityService.deniedFor(userFile.getPdm())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        userFile.setCanceled(true);
        log.info("User file {}/{} (#{}) aborted.", new Object[]{userFile.getGroup(), userFile.getName(), userFile.getId()});
    }
}

