/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.core.msg_fw.MessageForwardingService;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.core.services.pdm_in.StatusMessageService;
import de.rtb.pcon.features.bonus.utils.JsonUtils;
import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.ImpactType;
import de.rtb.pcon.model.MessageConfigDefault;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.repositories.MessageConfigDefaultRepository;
import de.rtb.pcon.repositories.PdmStatusRepository;
import de.rtb.pcon.repositories.StatusMessageRepository;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StatusMessageService {
    private static final Logger log = LoggerFactory.getLogger(StatusMessageService.class);
    private final MessageConfigDefaultRepository mcdRepo;
    private final StatusMessageRepository statusMessageRepo;
    private final PdmStatusRepository pdmStatusRepo;
    private final MessageForwardingService msgForwarderSrv;

    public StatusMessageService(MessageConfigDefaultRepository mcdRepo, StatusMessageRepository statusMessageRepo, PdmStatusRepository pdmStatusRepo, MessageForwardingService msgForwarderSrv) {
        this.mcdRepo = mcdRepo;
        this.statusMessageRepo = statusMessageRepo;
        this.pdmStatusRepo = pdmStatusRepo;
        this.msgForwarderSrv = msgForwarderSrv;
    }

    @Transactional
    public StatusMessage insertPmdMessage(PdmMessageDto msg) {
        OffsetDateTime serverTime = OffsetDateTime.now();
        OffsetDateTime pdmTime = Optional.ofNullable(msg.getDatTim()).orElseGet(() -> {
            log.warn("Time from PDM is not present in status message. Using now instead.");
            return serverTime;
        });
        StatusMessage st = new StatusMessage();
        st.setMessageConfig(this.mcdRepo.findById((Object)msg.getMnr()).orElseGet(() -> (MessageConfigDefault)this.mcdRepo.save((Object)StatusMessageService.createDefaultMessageConfig((int)msg.getMnr().shortValue()))));
        st.setTracer(msg.getTrc());
        st.setPdmTime(pdmTime);
        st.setServerTime(serverTime);
        st.setPdm(msg.getPdm());
        st.setReason(JsonUtils.writeValueAsString((Object)msg.getIie()));
        st = (StatusMessage)this.statusMessageRepo.save((Object)st);
        this.updatePdmStarus(st);
        this.msgForwarderSrv.fowardIfNeeded(st);
        return st;
    }

    @Transactional
    public void insertArtificialMessage(Pdm pdm, int number) {
        this.insertArtificialMessage(pdm, number, null);
    }

    @Transactional
    public void insertArtificialMessage(Pdm pdm, int number, ObjectNode reason) {
        OffsetDateTime now = OffsetDateTime.now();
        StatusMessage st = new StatusMessage();
        st.setPdm(pdm);
        st.setPdmTime(now.truncatedTo(ChronoUnit.MINUTES));
        st.setServerTime(now);
        st.setTracer(null);
        st.setMessageConfig(this.mcdRepo.findById((Object)((short)number)).orElseGet(() -> (MessageConfigDefault)this.mcdRepo.save((Object)StatusMessageService.createDefaultMessageConfig((int)number))));
        st.setReason(JsonUtils.writeValueAsString((Object)reason));
        st = (StatusMessage)this.statusMessageRepo.save((Object)st);
        this.updatePdmStarus(st);
        this.msgForwarderSrv.fowardIfNeeded(st);
        log.info("Manual message for {}@{} NMR{};IIE{}; inserted.", new Object[]{pdm.getNumber(), pdm.getZone().getArea().getId(), number, reason});
    }

    public static MessageConfigDefault createDefaultMessageConfig(int number) {
        MessageConfigDefault mc = new MessageConfigDefault();
        mc.setNumber(Short.valueOf((short)number));
        mc.setSolveNumber(null);
        mc.setAlertType(AlertType.NEW);
        mc.setType(ImpactType.TRANSIENT);
        mc.setManual(false);
        mc.setImportant(false);
        log.info("Configuration of message {} has been created.", (Object)number);
        return mc;
    }

    private void updatePdmStarus(StatusMessage msg) {
        MessageConfigDefault mc = msg.getMessageConfig();
        switch (1.$SwitchMap$de$rtb$pcon$model$ImpactType[mc.getType().ordinal()]) {
            case 1: {
                this.pdmStatusRepo.setStatus(msg.getPdm().getId().intValue(), (int)msg.getMessageConfig().getNumber().shortValue(), msg.getId().longValue());
                break;
            }
            case 2: {
                this.pdmStatusRepo.removeStatus(msg.getPdm().getId().intValue(), (int)msg.getMessageConfig().getNumber().shortValue());
                break;
            }
        }
    }
}

