/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import de.rtb.pcon.repositories.UserRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScalableResourcesConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(ScalableResourcesConfigurationService.class);
    private final int cpuCount;
    private final long heapCurrent;
    private final long heapMax;
    public final int crUiLogbookInit;
    public final int crUiLogbookMax;
    public final int crAareaServicesInit;
    public final int crAareaServicesMax;
    public final int crTracerGuardInit;
    public final int crTracerGuardMax;
    public final int crLastVoltageInit;
    public final int crLastVoltageMax;
    public final int crFwdRulesInit;
    public final int crFwdRulesMax;
    public final int crAreaPartnersInit;
    public final int crAreaPartnersMax;

    public ScalableResourcesConfigurationService(PdmRepository pdmRepo, UserRepository userRepo) {
        Runtime runtime = Runtime.getRuntime();
        this.cpuCount = runtime.availableProcessors();
        this.heapCurrent = runtime.totalMemory();
        this.heapMax = runtime.maxMemory();
        if (log.isInfoEnabled()) {
            log.info("Detected {} CPUs, heap size current {} MB, maximal {} MB.", new Object[]{this.cpuCount, this.heapCurrent / 0x100000L, this.heapMax / 0x100000L});
            long pdmCount = pdmRepo.count();
            long userCount = userRepo.count();
            log.info("There is {} PDMs and {} users.", (Object)pdmCount, (Object)userCount);
        }
        this.crUiLogbookInit = 5;
        this.crUiLogbookMax = 30;
        this.crAareaServicesInit = 0;
        this.crAareaServicesMax = 30;
        this.crTracerGuardInit = 100;
        this.crTracerGuardMax = 10000;
        this.crLastVoltageInit = 100;
        this.crLastVoltageMax = 1000;
        this.crFwdRulesInit = 100;
        this.crFwdRulesMax = 1000;
        this.crAreaPartnersInit = 100;
        this.crAreaPartnersMax = 1000;
        this.printResourceConfiguration();
    }

    public void printResourceConfiguration() {
        if (log.isDebugEnabled()) {
            log.debug("Cache regions: ");
            log.debug(" + Log-book: {} / {}", (Object)this.crUiLogbookInit, (Object)this.crUiLogbookMax);
            log.debug(" + AreaService: {} / {}", (Object)this.crAareaServicesInit, (Object)this.crAareaServicesMax);
            log.debug(" + Tracer guard: {} / {}", (Object)this.crTracerGuardInit, (Object)this.crTracerGuardMax);
            log.debug(" + Last voltage: {} / {}", (Object)this.crLastVoltageInit, (Object)this.crLastVoltageMax);
            log.debug(" + Forwarding rules: {} / {}", (Object)this.crFwdRulesInit, (Object)this.crFwdRulesMax);
        }
    }
}

