/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.model.PaymentTransactionId;
import java.time.Instant;

public record ExtensiblePermitDbId(@JsonProperty(value="pdm") Integer pdmId, @JsonIgnore Instant payTs, @JsonProperty(value="trc") Integer tracer) {
    @JsonProperty(value="pdm")
    private final Integer pdmId;
    @JsonIgnore
    private final Instant payTs;
    @JsonProperty(value="trc")
    private final Integer tracer;

    public ExtensiblePermitDbId(PaymentTransactionId payId) {
        this(payId.getPdm().getId(), payId.getPdmTime().toInstant(), payId.getTrc());
    }

    public ExtensiblePermitDbId(@JsonProperty(value="pdm") Integer pdmId, Instant payTs, @JsonProperty(value="trc") Integer tracer) {
        this.pdmId = pdmId;
        this.payTs = payTs;
        this.tracer = tracer;
    }

    @JsonCreator
    public static ExtensiblePermitDbId fromJson(@JsonProperty(value="pdm") Integer pdmId, @JsonProperty(value="pay") Long pay, @JsonProperty(value="trc") Integer trc) {
        Instant payInstant = Instant.ofEpochSecond(pay);
        return new ExtensiblePermitDbId(pdmId, payInstant, trc);
    }

    @JsonGetter(value="pay")
    public Long payJson() {
        return this.payTs.getEpochSecond();
    }

    @JsonProperty(value="pdm")
    public Integer pdmId() {
        return this.pdmId;
    }

    @JsonIgnore
    public Instant payTs() {
        return this.payTs;
    }

    @JsonProperty(value="trc")
    public Integer tracer() {
        return this.tracer;
    }
}

