/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.runtime_monitor;

import de.rtb.pcon.core.pdm.msg.json.ModemLoginDeviceReport;
import de.rtb.pcon.core.runtime_monitor.AliveMonitorService;
import de.rtb.pcon.core.runtime_monitor.ModemLoginRepository;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.ModemLogin;
import de.rtb.pcon.model.NetworkType;
import de.rtb.pcon.model.PdmRuntimeMonitor;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModemLogingService {
    private static final Logger log = LoggerFactory.getLogger(ModemLogingService.class);
    private final ModemLoginRepository modemLoginRepo;
    private final AliveMonitorService aliveMonitorService;

    public ModemLogingService(ModemLoginRepository modemLoginRepo, AliveMonitorService aliveMonitorService) {
        this.modemLoginRepo = modemLoginRepo;
        this.aliveMonitorService = aliveMonitorService;
    }

    @Transactional
    public void procesModemSignalAndLogin(PdmMessageDto m, PdmRuntimeMonitor pdmRtm) {
        Optional modemLogin;
        if (m.getRdm() != null) {
            log.debug("~ Modem login");
            modemLogin = this.createModemLogin7(m);
        } else {
            modemLogin = m.getCsq() != null ? this.recievedModemSignalStrength(m, pdmRtm) : Optional.empty();
        }
        modemLogin.ifPresent(ml -> {
            this.aliveMonitorService.updateModemStatus(pdmRtm, Integer.valueOf(ml.getSignalStrength().shortValue()), ml.getNetType(), ml.getPdmTime());
            this.modemLoginRepo.save(ml);
        });
    }

    Optional<ModemLogin> recievedModemSignalStrength(PdmMessageDto m, PdmRuntimeMonitor pdmRtm) {
        Integer strength = m.getCsq();
        if (strength < 0 || strength > 31) {
            log.trace("Mobile network signal strength {} is out of range <0 - 31> and will be ignored.", (Object)strength);
            return Optional.empty();
        }
        short netSignalPercent = this.asuToPercentGprs(strength.intValue());
        return Optional.of(pdmRtm).filter(r -> r.getNetSignal() == null || netSignalPercent != r.getNetSignal()).map(r -> {
            r.setNetSignal(strength);
            return new ModemLogin(m.getPdm(), m.getDatTim(), Short.valueOf(netSignalPercent), NetworkType.GPRS);
        });
    }

    Optional<ModemLogin> createModemLogin7(PdmMessageDto m) {
        ModemLoginDeviceReport report = m.getRdm();
        ModemLogin ml = new ModemLogin(m.getPdm(), m.getDatTim(), Short.valueOf(report.getSignal()), report.getNetType());
        return Optional.of(ml);
    }

    short asuToPercentGprs(int asu) {
        return (short)Math.ceil((double)(100 * asu) / 31.0);
    }
}

