/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.parking_extension;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.parking_extension.ParkingExtensionService;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import java.util.Collection;
import java.util.Map;
import net.fellbaum.jemoji.EmojiManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
class PermitExtensionRtrPsn
implements RealTimeRequest {
    @Autowired
    private ParkingExtensionService parkingExtensionService;
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper pdmObjectMapper;

    PermitExtensionRtrPsn() {
    }

    public int getId() {
        return 5;
    }

    public String getDescription() {
        return "Parking permits (PSN)";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        int pan = ctx.getLocalInteger("PAN");
        Integer areaNr = ctx.global().getPdm().getZone().getArea().getId();
        Collection extendiblePermits = this.parkingExtensionService.findExtendablePermitsByPsn(pan, areaNr.intValue());
        extendiblePermits.forEach(ep -> {
            ep.setPrice(ep.getPrice().scaleByPowerOfTen(ctx.getMonetaryScale()));
            ep.setSellingPdmName(EmojiManager.removeAllEmojis((String)ep.getSellingPdmName()));
        });
        return Map.of("TIC", extendiblePermits);
    }
}

