/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.parking_extension;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.rtb.pcon.core.pdm.msg.json.conv.CompactDateTimeMinuteSerializer;
import de.rtb.pcon.core.services.pdm_in.ExtensiblePermitDbId;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import org.apache.commons.lang3.StringUtils;

class ExtendiblePermit {
    private BigDecimal price;
    @JsonSerialize(using=CompactDateTimeMinuteSerializer.class)
    private LocalDateTime start;
    @JsonSerialize(using=CompactDateTimeMinuteSerializer.class)
    private LocalDateTime end;
    @JsonProperty(value="tar")
    private String tariffName;
    @JsonProperty(value="tnum")
    private int permitNumber;
    @JsonProperty(value="pnum")
    private int sellingPdmNumber;
    @JsonProperty(value="name")
    private String sellingPdmName;
    @JsonProperty(value="tol")
    private int tolerance;
    @JsonProperty(value="pen")
    private BigDecimal penaltyFee;
    private int parts;
    @JsonProperty(value="mparts")
    private int maxParts;
    @JsonProperty(value="mdur")
    private int maxDuration;
    @JsonProperty(value="mprice")
    private BigDecimal maxPrice;
    @JsonProperty(value="dbid")
    private ExtensiblePermitDbId paymentId;

    public ExtendiblePermit() {
    }

    public ExtendiblePermit(PaymentTransaction pt) {
        ZoneId zoneId = ZoneId.of(pt.getId().getPdm().getZone().getArea().getTimeZoneName());
        this.price = pt.getAmount().stripTrailingZeros();
        this.start = DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getId().getPdmTime(), (ZoneId)zoneId);
        this.end = DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getParkEndTime(), (ZoneId)zoneId);
        this.tariffName = pt.getTariffInfo() == null ? null : pt.getTariffInfo().getName();
        this.permitNumber = pt.getTicketNumber();
        this.paymentId = new ExtensiblePermitDbId(pt.getId());
        this.sellingPdmNumber = pt.getId().getPdm().getNumber();
        this.sellingPdmName = StringUtils.substring((String)pt.getId().getPdm().getName(), (int)0, (int)30);
        this.tolerance = 15;
        this.penaltyFee = new BigDecimal(5);
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public String getTariffName() {
        return this.tariffName;
    }

    public void setTariffName(String tariffName) {
        this.tariffName = tariffName;
    }

    public int getPermitNumber() {
        return this.permitNumber;
    }

    public void setPermitNumber(int permitNumber) {
        this.permitNumber = permitNumber;
    }

    public int getSellingPdmNumber() {
        return this.sellingPdmNumber;
    }

    public void setSellingPdmNumber(int sellingPdmNumber) {
        this.sellingPdmNumber = sellingPdmNumber;
    }

    public String getSellingPdmName() {
        return this.sellingPdmName;
    }

    public void setSellingPdmName(String sellingPdmName) {
        this.sellingPdmName = sellingPdmName;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    public BigDecimal getPenaltyFee() {
        return this.penaltyFee;
    }

    public void setPenaltyFee(BigDecimal penaltyFee) {
        this.penaltyFee = penaltyFee;
    }

    public int getParts() {
        return this.parts;
    }

    public void setParts(int parts) {
        this.parts = parts;
    }

    public int getMaxParts() {
        return this.maxParts;
    }

    public void setMaxParts(int maxParts) {
        this.maxParts = maxParts;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration = maxDuration;
    }

    public BigDecimal getMaxPrice() {
        return this.maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    public ExtensiblePermitDbId getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(ExtensiblePermitDbId paymentId) {
        this.paymentId = paymentId;
    }
}

