/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.notification.sms.lox24;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.collect.Range;
import de.rtb.pcon.core.notification.sms.SmsNotificationConfigurationProperties;
import de.rtb.pcon.core.notification.sms.SmsService;
import de.rtb.pcon.core.notification.sms.lox24.GwXmlResponseRoot;
import de.rtb.pcon.core.notification.sms.lox24.Lox24SmsServiceCondition;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="smsGateway")
@Conditional(value={Lox24SmsServiceCondition.class})
class Lox24SmsService
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(Lox24SmsService.class);
    private static final String HTTP_API_URL = "https://www.lox24.eu/API/httpsms.php";
    @Autowired
    private SmsNotificationConfigurationProperties config;
    private boolean enabled = false;
    private String paswordMd5 = null;
    private ObjectMapper xmlObjectMapper = new XmlMapper();

    @PostConstruct
    public void checkConfiguration() {
        log.debug("Starting Lox24 sms service");
        if (StringUtils.isBlank((CharSequence)this.config.getUsername()) || StringUtils.isBlank((CharSequence)this.config.getPassword()) || StringUtils.isBlank((CharSequence)this.config.getHumanType()) || StringUtils.isBlank((CharSequence)this.config.getMachineType())) {
            this.enabled = false;
            log.error("The Lox24 SMS service is not configured. Sending of SMS is disabled.");
            return;
        }
        try {
            byte[] pMd5Bin = MessageDigest.getInstance("MD5").digest(this.config.getPassword().getBytes(StandardCharsets.UTF_8));
            this.paswordMd5 = Hex.encodeHexString((byte[])pMd5Bin);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("MD5 algorithm doesn't exist, password is not set");
        }
        this.enabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(String receiver, String message) {
        if (!this.enabled) {
            log.info("Lox24: SMS was not send because the service is disabled.");
            return false;
        }
        boolean sendSuccessfully = false;
        String originalReciever = receiver;
        receiver = receiver.replaceAll("[\\s\\(\\)\\-]", "");
        log.debug("Lox24: Sending SMS: {} -> {} [{}].", new Object[]{originalReciever, receiver, message});
        Matcher updateSmsMatcher = MACHINE_SMS_PATTERN.matcher(message);
        String smsType = updateSmsMatcher.find() ? this.config.getMachineType() : this.config.getHumanType();
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost request = new HttpPost(HTTP_API_URL);
            ArrayList<BasicNameValuePair> requestParameters = new ArrayList<BasicNameValuePair>();
            requestParameters.add(new BasicNameValuePair("konto", this.config.getUsername()));
            requestParameters.add(new BasicNameValuePair("password", this.paswordMd5));
            requestParameters.add(new BasicNameValuePair("service", smsType));
            requestParameters.add(new BasicNameValuePair("text", message));
            requestParameters.add(new BasicNameValuePair("from", "P-Control"));
            requestParameters.add(new BasicNameValuePair("to", receiver));
            requestParameters.add(new BasicNameValuePair("return", "xml"));
            requestParameters.add(new BasicNameValuePair("httphead", "0"));
            requestParameters.add(new BasicNameValuePair("action", "send"));
            UrlEncodedFormEntity urlEncodedParameters = new UrlEncodedFormEntity(requestParameters, StandardCharsets.UTF_8);
            request.setEntity((HttpEntity)urlEncodedParameters);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            try (InputStreamReader responseInputStreamReader = new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8);){
                GwXmlResponseRoot gwResponse = (GwXmlResponseRoot)this.xmlObjectMapper.readValue((Reader)responseInputStreamReader, GwXmlResponseRoot.class);
                if (Range.closed((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(199)).contains((Comparable)Integer.valueOf(gwResponse.getCode()))) {
                    if (log.isDebugEnabled()) {
                        log.debug("Lox24: SMS sent. Result {}: ('{}' / '{}'), MessageID: {}, Cost: {}.", new Object[]{gwResponse.getCode(), this.responseCodeToText(gwResponse.getCode()), gwResponse.getDescription(), gwResponse.getInfo().getMsgId(), gwResponse.getInfo().getCost()});
                    }
                    sendSuccessfully = true;
                    log.debug("Message has been sent to {}.", (Object)receiver);
                } else {
                    if (gwResponse.getInfo() != null) {
                        if (log.isErrorEnabled()) {
                            log.error("Lox24: SMS failed. Result {}: ('{}' / '{}') [msgId {}, cost: {}, text: {}].", new Object[]{gwResponse.getCode(), this.responseCodeToText(gwResponse.getCode()), gwResponse.getDescription(), gwResponse.getInfo().getMsgId(), gwResponse.getInfo().getCost(), gwResponse.getInfo().getText()});
                        }
                    } else if (log.isErrorEnabled()) {
                        log.error("Lox24: SMS failed. Result {}: ('{}' / '{}').", new Object[]{gwResponse.getCode(), this.responseCodeToText(gwResponse.getCode()), gwResponse.getDescription()});
                    }
                    sendSuccessfully = false;
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (IOException e) {
            log.error("Lox24: Failed to process sms send", (Throwable)e);
        }
        return sendSuccessfully;
    }

    private String responseCodeToText(int responseCode) {
        switch (responseCode) {
            case 100: {
                return "SMS transmitted successfully";
            }
            case 101: {
                return "Successful query";
            }
            case 102: {
                return "Command executed";
            }
            case 200: {
                return "User-ID, Password or Service-ID wrong";
            }
            case 201: {
                return "No Text";
            }
            case 202: {
                return "No Recipient";
            }
            case 203: {
                return "Text too long (>1520 characters)";
            }
            case 204: {
                return "Not enough credit line / account balance";
            }
            case 205: {
                return "No MMS data";
            }
            case 206: {
                return "MMS file size too big";
            }
            case 207: {
                return "Invalid IP";
            }
            case 208: {
                return "Destination country or network is blocked";
            }
            case 209: {
                return "Invalid XML-Schema";
            }
            case 210: {
                return "Invalid Sender-ID";
            }
            case 211: {
                return "Invalid Parameter for Encoding";
            }
            case 300: {
                return "System error. Please contact support berlin@lox24.eu";
            }
            case 301: {
                return "SMS could not be transmitted";
            }
            case 302: {
                return "Connection error";
            }
            case 400: {
                return "Maintenance! The service is not available at this time. Please try again later.";
            }
        }
        return "Unknown code " + responseCode + ".";
    }
}

