/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.notification;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

class PriorityResourceLoader
implements ResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(PriorityResourceLoader.class);
    private ResourceLoader resourceLoader;
    private List<Resource> locations;
    private static final Resource NON_EXISTING_RESOURCE = PriorityResourceLoader.nonExistingResource();

    public PriorityResourceLoader(ResourceLoader resourceLoader, List<Optional<String>> locations, Logger logger) {
        this.resourceLoader = resourceLoader;
        this.locations = new LinkedList();
        for (Optional<String> location : locations) {
            if (location.isEmpty()) continue;
            String path = StringUtils.appendIfMissing((String)location.get(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            Resource pathResource = resourceLoader.getResource(path);
            if (pathResource.exists()) {
                this.locations.add(pathResource);
                continue;
            }
            logger.error("Path '{}' does not exist and will be ignored", (Object)pathResource);
        }
        if (log.isTraceEnabled()) {
            log.trace("Resources will be loaded from locations: {}", (Object)this.locations.stream().map(Resource::getDescription).collect(Collectors.joining(", ")));
        }
    }

    public PriorityResourceLoader(ResourceLoader resourceLoader, List<Optional<String>> locations) {
        this(resourceLoader, locations, log);
    }

    public Resource getResource(String name) {
        Resource resource = NON_EXISTING_RESOURCE;
        Iterator pathResourceIterator = this.locations.iterator();
        while (pathResourceIterator.hasNext() && !resource.exists()) {
            Resource pathResource = (Resource)pathResourceIterator.next();
            try {
                resource = pathResource.createRelative(name);
            }
            catch (IOException e) {
                log.error("Cannot create relative resource {}.", (Object)resource);
                resource = NON_EXISTING_RESOURCE;
            }
        }
        Resource resource2 = resource = resource.exists() ? resource : NON_EXISTING_RESOURCE;
        if (log.isDebugEnabled()) {
            if (resource.exists()) {
                log.debug("Resource '{}' was resolved to '{}'.", (Object)name, (Object)resource.getDescription());
            } else {
                log.trace("Resource '{}' was not found", (Object)name);
            }
        }
        return resource;
    }

    public ClassLoader getClassLoader() {
        return this.resourceLoader.getClassLoader();
    }

    private static Resource nonExistingResource() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static String normalizeFileSystemPath(String userPath) {
        Object result = null;
        if (userPath != null) {
            File userTemplatesPath = new File(userPath);
            if (userTemplatesPath.isAbsolute()) {
                result = "file:" + userTemplatesPath.getPath();
                log.trace("Relative path '{}' converted to full with protocol '{}'", (Object)userTemplatesPath.getPath(), result);
            } else {
                result = userTemplatesPath.getPath();
            }
            if (log.isDebugEnabled()) {
                log.debug("User path resolved to '{}'", (Object)Objects.requireNonNullElse(result, "null"));
            }
        }
        return result;
    }
}

