/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_presistence.payment.cpf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.core.msg_presistence.payment.cpf.CpfJsonDto;
import de.rtb.pcon.core.msg_presistence.payment.cpf.CpfOperation;
import de.rtb.pcon.core.msg_presistence.payment.cpf.CustomPaymentFieldService;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.repositories.PaymentTransactionRepository;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomPaymentFieldService {
    private static final Logger log = LoggerFactory.getLogger(CustomPaymentFieldService.class);
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper pdmObjectMapper;
    @Autowired
    private ObjectMapper stdObjectMapper;
    @Autowired
    private PaymentTransactionRepository paymentRepo;
    private static final TypeReference<Map<String, Object>> JACKSON_VALUE_MAP_TYPE_REFRENCE = new /* Unavailable Anonymous Inner Class!! */;

    @Transactional
    public void createCpf(PaymentTransaction payment, ObjectNode cpfData) {
        this.parseCpf(cpfData).ifPresent(cpf -> this.setCpf(payment, cpf.getCpfData()));
    }

    @Transactional
    public void modifyCpf(Pdm pdm, ObjectNode cpfData) {
        this.parseCpf(cpfData).flatMap(cpf -> {
            ZonedDateTime from = ZonedDateTime.of(cpf.getHeader().getTimestamp(), ZoneId.of(pdm.getZone().getArea().getTimeZoneName()));
            ZonedDateTime to = from.plusMinutes(1L);
            Integer ticket = cpf.getHeader().getTicketNumber();
            Optional payment = this.paymentRepo.findByIdPdmAndTicketNumberAndIdPdmTimeBetween(pdm, ticket.intValue(), from.toOffsetDateTime(), to.toOffsetDateTime());
            if (payment.isEmpty()) {
                log.warn("Payment for CPF was not found. Pdm #{}, {}", (Object)pdm.getId(), (Object)cpfData);
            }
            return payment.map(p -> Pair.of((Object)p, (Object)cpf));
        }).ifPresent(pair -> {
            PaymentTransaction payment = (PaymentTransaction)pair.getLeft();
            CpfJsonDto cpf = (CpfJsonDto)pair.getRight();
            CpfOperation operation = cpf.getHeader().getOperation();
            Map data = cpf.getCpfData();
            switch (2.$SwitchMap$de$rtb$pcon$core$msg_presistence$payment$cpf$CpfOperation[operation.ordinal()]) {
                case 1: {
                    this.setCpf(payment, data);
                    break;
                }
                case 2: {
                    this.updateData(payment, data);
                    break;
                }
                case 3: {
                    this.deleteData(payment, (Collection)cpf.getHeader().getKeysToDelete());
                }
            }
        });
    }

    private void setCpf(PaymentTransaction payment, Map<String, Object> cpfData) {
        payment.setData(this.mapToJsonString(cpfData));
    }

    private void updateData(PaymentTransaction payment, Map<String, Object> newCpfData) {
        this.jsonStringToMap(payment.getData()).ifPresentOrElse(dbDataMap -> {
            dbDataMap.putAll(newCpfData);
            this.setCpf(payment, dbDataMap);
        }, () -> this.setCpf(payment, newCpfData));
    }

    private void deleteData(PaymentTransaction payment, Collection<String> keysToRemove) {
        this.jsonStringToMap(payment.getData()).ifPresent(dbDataMap -> {
            keysToRemove.forEach(dbDataMap::remove);
            this.setCpf(payment, dbDataMap);
        });
    }

    private Optional<CpfJsonDto> parseCpf(ObjectNode cpfData) {
        return Optional.ofNullable(cpfData).map(cpf -> (CpfJsonDto)this.pdmObjectMapper.convertValue(cpf, CpfJsonDto.class));
    }

    private Optional<Map<String, Object>> jsonStringToMap(String cpfData) {
        if (StringUtils.isEmpty((CharSequence)cpfData)) {
            return Optional.empty();
        }
        try {
            return Optional.of((Map)this.stdObjectMapper.readValue(cpfData, JACKSON_VALUE_MAP_TYPE_REFRENCE));
        }
        catch (JsonProcessingException e) {
            log.error("Cannot parse payment data.", (Throwable)e);
            return Optional.empty();
        }
    }

    private String mapToJsonString(Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            log.debug("Serialization of empty data was skipped.");
            return null;
        }
        try {
            return this.stdObjectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

