/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_fw;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.msgfw.MessageForwardingRule;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class UiForwardingRuleLong {
    private Integer id;
    private int area;
    private String name;
    private boolean enabled;
    private String receivers;
    private Set<Integer> pdmNumbers;
    private Set<Integer> messageNumbers;
    private Set<AlertType> alerts;
    private Set<Integer> days;
    private LocalTime from;
    private LocalTime to;

    public UiForwardingRuleLong() {
    }

    public UiForwardingRuleLong(MessageForwardingRule rule) {
        this.id = rule.getId();
        this.area = rule.getArea().getId();
        this.name = rule.getName();
        this.enabled = rule.isActive();
        this.pdmNumbers = Optional.ofNullable(rule.getPdmNumbers()).orElse(List.of()).stream().collect(Collectors.toSet());
        this.messageNumbers = Optional.ofNullable(rule.getMessageNumbers()).orElse(List.of()).stream().collect(Collectors.toSet());
        this.alerts = Optional.ofNullable(rule.getAlertTypes()).orElse(List.of()).stream().collect(Collectors.toSet());
        this.receivers = rule.getReceivers();
        this.from = rule.getTimeBegin();
        this.to = rule.getTimeEnd();
        this.days = Optional.ofNullable(rule.getDaysOfWeek()).orElse(List.of()).stream().map(DayOfWeek::getValue).collect(Collectors.toSet());
    }

    @JsonGetter(value="alerts")
    public List<Integer> getAlertsJson() {
        return this.alerts.stream().map(Enum::ordinal).collect(Collectors.toList());
    }

    @JsonSetter(value="alerts")
    public void setAlertsJson(List<Integer> alerts) {
        this.alerts = alerts != null ? alerts.stream().map(AlertType::fromOrdinal).collect(Collectors.toSet()) : Set.of();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getArea() {
        return this.area;
    }

    public void setArea(int area) {
        this.area = area;
    }

    public String getReceivers() {
        return this.receivers;
    }

    public void setReceivers(String receivers) {
        this.receivers = receivers;
    }

    public Set<Integer> getPdmNumbers() {
        return this.pdmNumbers;
    }

    public void setPdmNumbers(Set<Integer> pdmNumbers) {
        this.pdmNumbers = pdmNumbers;
    }

    public Set<Integer> getMessageNumbers() {
        return this.messageNumbers;
    }

    public void setMessageNumbers(Set<Integer> messageNumbers) {
        this.messageNumbers = messageNumbers;
    }

    public Set<AlertType> getAlerts() {
        return this.alerts;
    }

    public void setAlerts(Set<AlertType> alerts) {
        this.alerts = alerts;
    }

    public Set<Integer> getDays() {
        return this.days;
    }

    public void setDays(Set<Integer> days) {
        this.days = days;
    }

    public LocalTime getFrom() {
        return this.from;
    }

    public void setFrom(LocalTime from) {
        this.from = from;
    }

    public LocalTime getTo() {
        return this.to;
    }

    public void setTo(LocalTime to) {
        this.to = to;
    }
}

