/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_fw;

import de.rtb.pcon.core.events.UserUpdatedEvent;
import de.rtb.pcon.core.msg_fw.MessageForwardingDefalultDataProviderService;
import de.rtb.pcon.core.msg_fw.MessageForwardingRuleDefinition;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.msgfw.MessageForwardingRule;
import de.rtb.pcon.repositories.MessageForwardingRuleRepository;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
class MessageForwardingDataProviderService {
    private static final Logger log = LoggerFactory.getLogger(MessageForwardingDataProviderService.class);
    private final MessageForwardingRuleRepository msgFwRepo;
    private final MessageForwardingDefalultDataProviderService msgCfgDefaultSevice;

    public MessageForwardingDataProviderService(MessageForwardingRuleRepository msgFwRepo, MessageForwardingDefalultDataProviderService msgCfgDefaultSevice) {
        this.msgFwRepo = msgFwRepo;
        this.msgCfgDefaultSevice = msgCfgDefaultSevice;
    }

    @Transactional
    public Optional<MessageForwardingRule> findById(int ruleId) {
        return this.msgFwRepo.findById((Object)ruleId);
    }

    @Cacheable(cacheNames={"fwd-rules"}, key="#area.getId()")
    @Transactional(readOnly=true)
    public List<MessageForwardingRuleDefinition> gerAreaRuleDefinitions(Area area) {
        if (log.isTraceEnabled()) {
            log.trace("Loading message forwarding rules for {}.", (Object)LoggerUtils.log((Area)area));
        }
        Set essentialStatuses = this.msgCfgDefaultSevice.getEssentialMessageNumber();
        return this.msgFwRepo.findByArea(area).stream().map(r -> MessageForwardingRuleDefinition.fromEntity((MessageForwardingRule)r, (Set)essentialStatuses)).filter(MessageForwardingRuleDefinition::active).toList();
    }

    @CacheEvict(cacheNames={"fwd-rules"}, key="#rule.getArea().getId()")
    @Transactional
    public MessageForwardingRule saveRule(MessageForwardingRule rule) {
        if (log.isTraceEnabled()) {
            log.trace("Evicted cache for message forwarding rules of {}.", (Object)LoggerUtils.log((Area)rule.getArea()));
        }
        return (MessageForwardingRule)this.msgFwRepo.save((Object)rule);
    }

    @CacheEvict(cacheNames={"fwd-rules"}, key="#rule.getArea().getId()")
    @Transactional
    public void deleteRule(MessageForwardingRule rule) {
        if (log.isTraceEnabled()) {
            log.trace("Evicted cache for message forwarding rules of {}.", (Object)LoggerUtils.log((Area)rule.getArea()));
        }
        this.msgFwRepo.delete((Object)rule);
    }

    @EventListener
    @CacheEvict(cacheNames={"fwd-rules"}, allEntries=true)
    void handleUserUpdated(UserUpdatedEvent event) {
        log.trace("User {} was updated. Evicting message forwarding caches.", (Object)event.getUserId());
    }
}

