/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_fw;

import de.rtb.pcon.core.msg_fw.MessageForwardingController;
import de.rtb.pcon.core.msg_fw.MessageForwardingDataProviderService;
import de.rtb.pcon.core.msg_fw.UiForwardRulePatch;
import de.rtb.pcon.core.msg_fw.UiForwardingRuleLong;
import de.rtb.pcon.core.msg_fw.UiForwardingRuleShort;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.msgfw.MessageForwardingRule;
import de.rtb.pcon.repositories.MessageForwardingRuleRepository;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RequestMapping(path={"/api/pcon/ui/msg-fws"})
@RestController
class MessageForwardingController {
    private static final Logger log = LoggerFactory.getLogger(MessageForwardingController.class);
    private static final Logger logActoin = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @PersistenceContext
    private EntityManager entityManger;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private MessageForwardingDataProviderService forwardDataService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private I18nService i18n;
    @Autowired
    private MessageForwardingRuleRepository msgFwRepo;

    MessageForwardingController() {
    }

    @GetMapping
    @Transactional(readOnly=true)
    public List<UiForwardingRuleShort> listRules(@RequestParam(value="area") int areaId) {
        Area area = this.entityLoader.loadArea(areaId);
        User user = this.securityService.getCurrentUser();
        return this.msgFwRepo.findByArea(area).stream().filter(r -> this.canRuleBeManipulatedByUser(r, user)).map(r -> new UiForwardingRuleShort(r, user)).toList();
    }

    /*
     * Enabled aggressive block sorting
     */
    @PutMapping
    @Transactional
    public ResponseEntity<UiForwardingRuleLong> putMessageForwarding(@RequestBody UiForwardingRuleLong uiRule) {
        MessageForwardingRule rule;
        User user = this.securityService.getCurrentUser();
        Optional<Area> requiredAreaOpt = this.securityService.getCurrentAreas().stream().filter(a -> Objects.equals(a.getId(), uiRule.getArea())).findAny();
        if (requiredAreaOpt.isEmpty()) {
            log.atWarn().setMessage("The {} requested to create / modify message forwarding in area {} which he does not have right to.").addArgument(() -> LoggerUtils.log((User)user)).addArgument((Object)uiRule.getArea()).log();
            logActoin.atError().setMessage("The {} requested to create / modify message forwarding in area {} which he does not have right to.").addArgument(() -> LoggerUtils.log((User)user)).addArgument((Object)uiRule.getArea());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        Area area = requiredAreaOpt.get();
        if (uiRule.getId() != null) {
            Optional ruleOpt = this.forwardDataService.findById(uiRule.getId().intValue());
            if (!ruleOpt.isPresent()) {
                log.warn("Forwarding rule #{} requested by {} does not exist.", (Object)uiRule.getId(), (Object)LoggerUtils.log((User)user));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
            }
            rule = (MessageForwardingRule)ruleOpt.get();
        } else {
            rule = new MessageForwardingRule();
            rule.setArea(area);
            rule.setUser(user);
            rule.setAlertTypes(List.of());
            rule.setPdmNumbers(List.of());
            rule.setMessageNumbers(List.of());
        }
        boolean isOwner = Objects.equals(rule.getUser(), user);
        boolean isAdmin = this.securityService.hasRole(UserRole.ROLE_PCON_MSG_FORWARD_ADMIN);
        if (!isOwner && !isAdmin) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        ChangeLogCollector changeLogCollector = new ChangeLogCollector();
        String userLanguage = this.i18n.getUserLocale().toLanguageTag();
        changeLogCollector.updateAndLog("enabled", (Object)rule.isActive(), (Object)uiRule.isEnabled(), arg_0 -> ((MessageForwardingRule)rule).setActive(arg_0));
        changeLogCollector.updateAndLog("name", (Object)rule.getName(), (Object)uiRule.getName(), arg_0 -> ((MessageForwardingRule)rule).setName(arg_0));
        changeLogCollector.updateAndLog("PDMs", rule.getPdmNumbers(), new ArrayList(uiRule.getPdmNumbers()), arg_0 -> ((MessageForwardingRule)rule).setPdmNumbers(arg_0));
        changeLogCollector.updateAndLog("messages", rule.getMessageNumbers(), new ArrayList(uiRule.getMessageNumbers()), arg_0 -> ((MessageForwardingRule)rule).setMessageNumbers(arg_0));
        changeLogCollector.updateAndLog("recipients", (Object)rule.getReceivers(), (Object)uiRule.getReceivers(), arg_0 -> ((MessageForwardingRule)rule).setReceivers(arg_0));
        changeLogCollector.updateAndLog("alerts", rule.getAlertTypes(), new ArrayList(uiRule.getAlerts()), arg_0 -> ((MessageForwardingRule)rule).setAlertTypes(arg_0));
        changeLogCollector.updateAndLog("language", (Object)rule.getLanguageTag(), (Object)userLanguage, arg_0 -> ((MessageForwardingRule)rule).setLanguageTag(arg_0));
        changeLogCollector.updateAndLog("from", (Object)rule.getTimeBegin(), (Object)uiRule.getFrom(), arg_0 -> ((MessageForwardingRule)rule).setTimeBegin(arg_0));
        changeLogCollector.updateAndLog("to", (Object)rule.getTimeEnd(), (Object)uiRule.getTo(), arg_0 -> ((MessageForwardingRule)rule).setTimeEnd(arg_0));
        List<DayOfWeek> daysOfWeek = uiRule.getDays().stream().sorted().map(DayOfWeek::of).toList();
        changeLogCollector.updateAndLog("days", rule.getDaysOfWeek(), daysOfWeek, arg_0 -> ((MessageForwardingRule)rule).setDaysOfWeek(arg_0));
        if (changeLogCollector.hasEntries() && logActoin.isInfoEnabled()) {
            logActoin.info("The {} has changed properties of message forwarding #{}: {}", new Object[]{LoggerUtils.log((User)user), rule.getId(), changeLogCollector});
        }
        HttpStatus resultStatus = rule.getId() == null ? HttpStatus.CREATED : HttpStatus.OK;
        return ResponseEntity.status((HttpStatusCode)resultStatus).body((Object)new UiForwardingRuleLong(this.forwardDataService.saveRule(rule)));
    }

    @PatchMapping
    @Transactional
    public UiForwardRulePatch patchRule(@RequestBody UiForwardRulePatch patch) {
        MessageForwardingRule fwr;
        User user = this.securityService.getCurrentUser();
        if (!Objects.equals(user, (fwr = this.loadForwardingRule(patch.getId(), user)).getUser())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (Objects.nonNull(patch.getEnabled())) {
            fwr.setActive(patch.getEnabled().booleanValue());
        }
        return UiForwardRulePatch.of((MessageForwardingRule)this.forwardDataService.saveRule(fwr));
    }

    @GetMapping(value={"{id}"})
    @Transactional(readOnly=true)
    public UiForwardingRuleLong getRuleDetail(@PathVariable(value="id") int ruleId) {
        User user = this.securityService.getCurrentUser();
        MessageForwardingRule fwr = this.loadForwardingRule(Integer.valueOf(ruleId), user);
        return new UiForwardingRuleLong(fwr);
    }

    @DeleteMapping(value={"{id}"})
    @Transactional
    public ResponseEntity<UiForwardingRuleLong> delteRule(@PathVariable(value="id") int ruleId) {
        User user = this.securityService.getCurrentUser();
        MessageForwardingRule fwr = this.loadForwardingRule(Integer.valueOf(ruleId), user);
        this.forwardDataService.deleteRule(fwr);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).build();
    }

    @PostMapping(value={"{id}/copy"})
    @Transactional
    public void copyRule(@PathVariable(value="id") int ruleId) {
        User user;
        MessageForwardingRule fwr = (MessageForwardingRule)this.forwardDataService.findById(ruleId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        if (!this.canRuleBeManipulatedByUser(fwr, user = this.securityService.getCurrentUser())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        this.entityManger.detach((Object)fwr);
        fwr.setId(null);
        fwr.setName(this.i18n.getLocalizedMessage("global.copyOf", new Object[]{fwr.getName()}));
        fwr.setUser(user);
        this.forwardDataService.saveRule(fwr);
        logActoin.atInfo().setMessage("{} copied message forwarding rule {}.").addArgument(() -> StringUtils.capitalize((String)LoggerUtils.log((User)user))).addArgument(() -> LoggerUtils.log((MessageForwardingRule)fwr)).log();
    }

    MessageForwardingRule loadForwardingRule(Integer ruleId, User user) {
        MessageForwardingRule rule = (MessageForwardingRule)this.forwardDataService.findById(ruleId.intValue()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        if (this.canRuleBeManipulatedByUser(rule, user)) {
            return rule;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    boolean canRuleBeManipulatedByUser(MessageForwardingRule rule, User user) {
        boolean isRuleInUserArea = user.getAreas().contains(rule.getArea());
        if (!isRuleInUserArea) {
            return false;
        }
        boolean isMsgFwdManager = this.securityService.hasRole(UserRole.ROLE_PCON_MSG_FORWARD_ADMIN);
        return isMsgFwdManager || Objects.equals(user, rule.getUser());
    }
}

