/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.look_up.status_filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.look_up.status_filters.CacheStatusFilterRowMapper;
import de.rtb.pcon.core.look_up.status_filters.CacheStatusFiltersDto;
import de.rtb.pcon.core.look_up.status_filters.StatusFilterLookupDto;
import de.rtb.pcon.core.look_up.status_filters.StatusScanRowDto;
import de.rtb.pcon.core.look_up.status_filters.StatusScanRowMapper;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.repositories.MessageConfigDefaultRepository;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;

@Service
public class DbLookupStatusFilterService {
    private static final Logger log = LoggerFactory.getLogger(DbLookupStatusFilterService.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private NamedParameterJdbcTemplate jdbcTemplate;
    @Autowired
    private MessageConfigDefaultRepository msgDefaultRepo;
    private static final Duration PERSISTENCE_TRESHOLD = Duration.ofMillis(200L);
    private static final String CACHE_KEY = "STATUS_FILTER";
    private static final String LOGBOOK_TABLE = "control.logbook";
    private static final String SQL_LOGBOOK_MAX_ID = "SELECT max(log_id) FROM control.logbook";
    private static final String SQL_SELECT_CACHED_VALUES = "SELECT id, value::text, last_id FROM control.cache_permanent WHERE type='STATUS_FILTER'";
    private static String sqlUpdateCahcedValue = "UPDATE control.cache_permanent SET value = :json::jsonb, last_id = :lastId WHERE type = 'STATUS_FILTER'";
    private static String sqlInsertCahcedValue = "INSERT INTO control.cache_permanent (value, type, last_id) values(:json::jsonb, 'STATUS_FILTER', :lastId);";
    private static final String SQL_SCAN_STATUS_TABLE = "SELECT zon_area_id, array_agg(DISTINCT log_msg_nr) FROM %2$s\nJOIN %1$s.pdm ON pdm_id = log_pdm_id JOIN %1$s.zone ON pdm_zone_id = zon_id WHERE log_id BETWEEN :idStart AND :idEnd GROUP BY zon_area_id".formatted("control", "control.logbook");

    public synchronized List<StatusFilterLookupDto> getStatusFilters(Collection<Area> areas, boolean includeAll) {
        Set areaIds = areas.stream().map(Area::getId).collect(Collectors.toSet());
        return this.loadStatusCache(includeAll).stream().filter(c -> areaIds.contains(c.getArea())).toList();
    }

    private Collection<StatusFilterLookupDto> loadStatusCache(boolean includeAll) {
        long maxPaymentId = Objects.requireNonNullElse((Long)this.jdbcTemplate.queryForObject(SQL_LOGBOOK_MAX_ID, (SqlParameterSource)new MapSqlParameterSource(), Long.class), 0L);
        CacheStatusFiltersDto cachedStatusFiltes = null;
        try {
            cachedStatusFiltes = (CacheStatusFiltersDto)this.jdbcTemplate.queryForObject(SQL_SELECT_CACHED_VALUES, (SqlParameterSource)new MapSqlParameterSource(), (RowMapper)new CacheStatusFilterRowMapper(this.objectMapper));
        }
        catch (EmptyResultDataAccessException e) {
            log.info("Status meta data was not found in cache. New ones will be created.");
        }
        cachedStatusFiltes = Objects.requireNonNullElseGet(cachedStatusFiltes, CacheStatusFiltersDto::makeDefault);
        Instant tableScanStartInstant = Instant.now();
        List statusScanResult = this.scanStatusTable(cachedStatusFiltes.getLastUsedId().longValue(), maxPaymentId);
        Duration tableScanDuration = Duration.between(tableScanStartInstant, Instant.now());
        this.mergeData(cachedStatusFiltes.getAreas(), statusScanResult);
        if (tableScanDuration.compareTo(PERSISTENCE_TRESHOLD) > 0 || cachedStatusFiltes.getId() == null) {
            log.trace("Status table scan took {} ms. Saving to permanent cache.", (Object)tableScanDuration.toMillis());
            this.saveCache(cachedStatusFiltes, maxPaymentId);
        }
        List areaMessages = cachedStatusFiltes.getAreas();
        if (!includeAll) {
            Set essentialStatusNumbers = this.msgDefaultRepo.findByEssentialTrue().stream().map(mc -> mc.getNumber()).collect(Collectors.toSet());
            for (StatusFilterLookupDto aDto : areaMessages) {
                Set smList = aDto.getStatuses().stream().filter(essentialStatusNumbers::contains).collect(Collectors.toSet());
                aDto.setStatuses(smList);
            }
        }
        return areaMessages;
    }

    private void saveCache(CacheStatusFiltersDto cachedPaymentFiltes, long lastId) {
        try {
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("json", (Object)this.objectMapper.writeValueAsString((Object)cachedPaymentFiltes.getAreas()));
            params.addValue("lastId", (Object)lastId);
            if (cachedPaymentFiltes.getId() != null) {
                this.jdbcTemplate.update(sqlUpdateCahcedValue, (SqlParameterSource)params);
            } else {
                this.jdbcTemplate.update(sqlInsertCahcedValue, (SqlParameterSource)params);
            }
        }
        catch (JsonProcessingException e) {
            log.error("Failed to save cached payment enums.", (Throwable)e);
        }
    }

    private void mergeData(List<StatusFilterLookupDto> cache, List<StatusScanRowDto> scanResult) {
        Set cachedAreaIds = cache.stream().map(StatusFilterLookupDto::getArea).collect(Collectors.toSet());
        cache.forEach(c -> this.updateCachedValue(c, scanResult));
        List notInCache = scanResult.stream().filter(s -> !cachedAreaIds.contains(s.getArea())).collect(Collectors.toList());
        notInCache.stream().forEach(sr -> {
            StatusFilterLookupDto co = new StatusFilterLookupDto();
            co.setArea(Integer.valueOf(sr.getArea()));
            co.setStatuses(sr.getStatuses());
            cache.add(co);
        });
    }

    private void updateCachedValue(StatusFilterLookupDto cache, List<StatusScanRowDto> scanResult) {
        scanResult.stream().filter(v -> cache.getArea().equals(v.getArea())).findFirst().ifPresent(sr -> cache.getStatuses().addAll(sr.getStatuses()));
    }

    private List<StatusScanRowDto> scanStatusTable(long from, long to) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idStart", (Object)from);
        parameters.addValue("idEnd", (Object)to);
        return this.jdbcTemplate.query(SQL_SCAN_STATUS_TABLE, (SqlParameterSource)parameters, (RowMapper)new StatusScanRowMapper());
    }
}

