/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.look_up.payment_filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.look_up.payment_filters.CachePaymentFilterRowMapper;
import de.rtb.pcon.core.look_up.payment_filters.CachePaymentFiltersDto;
import de.rtb.pcon.core.look_up.payment_filters.PaymentFilterLookupDto;
import de.rtb.pcon.core.look_up.payment_filters.PaymentScanRowDto;
import de.rtb.pcon.core.look_up.payment_filters.PaymentScanRowMapper;
import de.rtb.pcon.model.Area;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;

@Service
public class DbLookupPaymentFilterService {
    private static final Logger log = LoggerFactory.getLogger(DbLookupPaymentFilterService.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private NamedParameterJdbcTemplate jdbcTemplate;
    private static final Duration PERSISTENCE_TRESHOLD = Duration.ofMillis(200L);
    private static final String CACHE_KEY = "PAYMENT_FILTER";
    private static final String SQL_RECENT_PAYMENT_MAX_ID = "SELECT max(id) FROM control.payment_recent";
    private static final String SQL_SELECT_CAHCED_VALUES = "SELECT id, value::text, last_id FROM control.cache_permanent WHERE type='PAYMENT_FILTER'";
    private static final String SQL_UPDATE_CAHCED_VALUE = "UPDATE control.cache_permanent SET value = :json::jsonb, last_id = :lastId WHERE type = 'PAYMENT_FILTER'";
    private static final String SQL_INSERT_CAHCED_VALUE = "INSERT INTO control.cache_permanent (value, type, last_id) values(:json::jsonb, 'PAYMENT_FILTER', :lastId);";
    private static final String SQL_SCAN_PAYMENT_TABLE = "SELECT\n  zon_area_id,\n  array_agg(DISTINCT payment.pay_reason)::varchar[],\n  array_agg(DISTINCT payment.pay_type)::varchar[],\n  array_agg(DISTINCT payment.tariff_info_id)\nFROM %1$s.payment_recent\nJOIN %1$s.payment ON payment.pay_ts = payment_recent.pay_ts AND payment.pdm_id = payment_recent.pdm_id\nJOIN %1$s.pdm ON pdm.pdm_id = payment_recent.pdm_id\nJOIN %1$s.zone ON pdm.pdm_zone_id = zone.zon_id\nWHERE %1$s.payment_recent.id BETWEEN :idStart AND :idEnd\nGROUP BY zone.zon_area_id".formatted("control");

    public synchronized List<PaymentFilterLookupDto> getPaymentFilters(Collection<Area> areas) {
        Set areaIds = areas.stream().map(Area::getId).collect(Collectors.toSet());
        return this.loadPaymentsCache().stream().filter(c -> areaIds.contains(c.getArea())).toList();
    }

    private List<PaymentFilterLookupDto> loadPaymentsCache() {
        long maxPaymentId = Objects.requireNonNullElse((Long)this.jdbcTemplate.queryForObject(SQL_RECENT_PAYMENT_MAX_ID, (SqlParameterSource)new MapSqlParameterSource(), Long.class), 0L);
        CachePaymentFiltersDto cachedPaymentFiltes = null;
        try {
            cachedPaymentFiltes = (CachePaymentFiltersDto)this.jdbcTemplate.queryForObject(SQL_SELECT_CAHCED_VALUES, (SqlParameterSource)new MapSqlParameterSource(), (RowMapper)new CachePaymentFilterRowMapper(this.objectMapper));
        }
        catch (EmptyResultDataAccessException e) {
            log.info("Payment meta data was not found in cache. New ones will be created.");
        }
        cachedPaymentFiltes = Objects.requireNonNullElseGet(cachedPaymentFiltes, CachePaymentFiltersDto::makeDefault);
        Instant tableScanStartInstant = Instant.now();
        List paymentScanResult = this.scanPaymentTable(cachedPaymentFiltes.getLastUsedId().longValue(), maxPaymentId);
        Duration tableScanDuration = Duration.between(tableScanStartInstant, Instant.now());
        this.mergeData(cachedPaymentFiltes.getAreas(), paymentScanResult);
        if (tableScanDuration.compareTo(PERSISTENCE_TRESHOLD) > 0 || cachedPaymentFiltes.getId() == null) {
            log.info("Payment table scan took {} ms. Saving to permanent cache.", (Object)tableScanDuration.toMillis());
            this.saveCache(cachedPaymentFiltes, maxPaymentId);
        }
        return cachedPaymentFiltes.getAreas();
    }

    private void saveCache(CachePaymentFiltersDto cachedPaymentFilters, long lastId) {
        try {
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("json", (Object)this.objectMapper.writeValueAsString((Object)cachedPaymentFilters.getAreas()));
            params.addValue("lastId", (Object)lastId);
            if (cachedPaymentFilters.getId() != null) {
                this.jdbcTemplate.update(SQL_UPDATE_CAHCED_VALUE, (SqlParameterSource)params);
            } else {
                this.jdbcTemplate.update(SQL_INSERT_CAHCED_VALUE, (SqlParameterSource)params);
            }
        }
        catch (JsonProcessingException e) {
            log.error("Failed to save cached payment enums.", (Throwable)e);
        }
    }

    private void mergeData(List<PaymentFilterLookupDto> cache, List<PaymentScanRowDto> scanResult) {
        Set cachedAreaIds = cache.stream().map(PaymentFilterLookupDto::getArea).collect(Collectors.toSet());
        cache.forEach(c -> this.updateCachedValue(c, scanResult));
        List notInCache = scanResult.stream().filter(s -> !cachedAreaIds.contains(s.getArea())).collect(Collectors.toList());
        notInCache.stream().forEach(sr -> {
            PaymentFilterLookupDto co = new PaymentFilterLookupDto();
            co.setArea(Integer.valueOf(sr.getArea()));
            co.setPaymentReasons(sr.getPaymentReasons());
            co.setPaymentTypes(sr.getPaymentTypes());
            co.setTariffIds(sr.getTariffIds());
            cache.add(co);
        });
    }

    private void updateCachedValue(PaymentFilterLookupDto cache, List<PaymentScanRowDto> scanResult) {
        scanResult.stream().filter(v -> cache.getArea().equals(v.getArea())).findFirst().ifPresent(sr -> {
            cache.getPaymentReasons().addAll(sr.getPaymentReasons());
            cache.getPaymentTypes().addAll(sr.getPaymentTypes());
            cache.getTariffIds().addAll(sr.getTariffIds());
        });
    }

    private List<PaymentScanRowDto> scanPaymentTable(long from, long to) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idStart", (Object)from);
        parameters.addValue("idEnd", (Object)to);
        return this.jdbcTemplate.query(SQL_SCAN_PAYMENT_TABLE, (SqlParameterSource)parameters, (RowMapper)new PaymentScanRowMapper());
    }
}

