/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.logging;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class PdmThreadLocalMarker {
    private static PdmThreadLocalMarker instance = null;
    private ThreadLocal<String> pdmId = ThreadLocal.withInitial(() -> "");
    private ThreadLocal<String> netSource = ThreadLocal.withInitial(() -> "");

    private PdmThreadLocalMarker() {
    }

    public static PdmThreadLocalMarker instance() {
        if (instance == null) {
            instance = new PdmThreadLocalMarker();
        }
        return instance;
    }

    public String getId() {
        return (String)this.pdmId.get();
    }

    public String getNetSource() {
        return (String)this.netSource.get();
    }

    public void setPdm(int pdmNr, Optional<Integer> area, Optional<String> cpu) {
        StringBuilder sb = new StringBuilder();
        sb.append(pdmNr);
        area.ifPresent(a -> {
            sb.append("@");
            sb.append(a);
        });
        if (area.isEmpty()) {
            cpu.ifPresent(c -> {
                sb.append("#");
                sb.append((String)c);
            });
        }
        this.pdmId.set(sb.toString());
    }

    @Deprecated
    public void setPdm(String nr, String area, String cpu) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)nr)) {
            int an = Integer.parseInt(nr);
            sb.append(an);
        } else {
            sb.append("?????");
        }
        if (StringUtils.isNotBlank((CharSequence)area)) {
            sb.append("@");
            int pnr = Integer.parseInt(area);
            sb.append(pnr);
        } else {
            sb.append("#");
            sb.append(cpu);
        }
        this.pdmId.set(sb.toString());
    }

    public void setNetSource(String addr, int port) {
        this.netSource.set(addr);
    }

    public void clear() {
        this.pdmId.remove();
        this.netSource.remove();
    }
}

