/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.core.integration.Crc16Calculator;
import de.rtb.pcon.core.integration.IntegrationConsts;
import de.rtb.pcon.core.integration.PdmInputProperties;
import de.rtb.pcon.core.integration.ServerResponse;
import de.rtb.pcon.core.integration.ServerResponseBinary;
import de.rtb.pcon.core.integration.ServerResponseBinaryFw5;
import de.rtb.pcon.core.integration.ServerResponseJson;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.serializer.Deserializer;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.stereotype.Component;

@Component
class UdpServer {
    private static final Logger log = LoggerFactory.getLogger(UdpServer.class);
    private final MessageChannel outputChannel = new DirectChannel();
    private final DatagramSocket socket;
    private final Executor taskExecutorMain;
    private final Executor taskExecutorAsm;
    private final Deserializer<byte[]> deserializer;

    public UdpServer(@Qualifier(value="taskExecutorS95Asm") Executor exeAsm, @Qualifier(value="taskExecutorS95Main") Executor exeMain, PdmInputProperties pdmInProps, Deserializer<byte[]> deserializer) {
        this.taskExecutorMain = exeMain;
        this.taskExecutorAsm = exeAsm;
        this.deserializer = deserializer;
        try {
            this.socket = new DatagramSocket(pdmInProps.getUdpPort());
        }
        catch (SocketException e) {
            throw new IllegalStateException("Cannot start UDP server", e);
        }
    }

    public MessageChannel getOutputChannel() {
        return this.outputChannel;
    }

    @PostConstruct
    void start() {
        this.taskExecutorAsm.execute(() -> this.reciveUdpPacketTask());
    }

    @PreDestroy
    void stop() {
        this.socket.close();
        log.info("UDP server has stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reciveUdpPacketTask() {
        try {
            byte[] receiveData = new byte[1024];
            DatagramPacket requestPacket = new DatagramPacket(receiveData, receiveData.length);
            this.socket.receive(requestPacket);
            byte[] pureData = (byte[])this.deserializer.deserialize((InputStream)new ByteArrayInputStream(receiveData));
            this.taskExecutorMain.execute(() -> {
                Message springMessage = ((MessageBuilder)((MessageBuilder)MessageBuilder.withPayload((Object)pureData).setHeader("ip_address", (Object)requestPacket.getAddress().getHostAddress())).setHeader("ip_port", (Object)requestPacket.getPort())).build();
                this.outputChannel.send(springMessage);
            });
        }
        catch (Exception e) {
            log.error("Exception in UDP receiver.", ExceptionUtils.getRootCause((Throwable)e));
        }
        finally {
            if (!this.socket.isClosed()) {
                this.taskExecutorAsm.execute(() -> this.reciveUdpPacketTask());
            }
        }
    }

    void sendMessageToPdm(Message<?> genericMessage) {
        ServerResponse payload = (ServerResponse)genericMessage.getPayload();
        MessageHeaders headers = genericMessage.getHeaders();
        String netAddressStr = Objects.requireNonNull((String)headers.get((Object)"ip_address", String.class));
        Integer netPort = Objects.requireNonNull((Integer)headers.get((Object)"ip_port", Integer.class));
        ServerResponse serverResponse = payload;
        Objects.requireNonNull(serverResponse);
        ServerResponse serverResponse2 = serverResponse;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ServerResponseJson.class, ServerResponseBinaryFw5.class, ServerResponseBinary.class}, (Object)serverResponse2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ServerResponseJson j = (ServerResponseJson)serverResponse2;
                this.sendTextMessage(j, netAddressStr, netPort.intValue());
                break;
            }
            case 1: {
                ServerResponseBinaryFw5 f5 = (ServerResponseBinaryFw5)serverResponse2;
                this.sendFirmware(f5, netAddressStr, netPort.intValue());
                break;
            }
            case 2: {
                ServerResponseBinary bin = (ServerResponseBinary)serverResponse2;
                throw new UnsupportedOperationException("Sending generic binary data is not supported in UDP mode");
            }
        }
    }

    private void sendTextMessage(ServerResponseJson srvRsp, String netAddressStr, int netPort) {
        String r = srvRsp.toTextPdm5();
        byte[] bytes = ServerResponseJson.makeBinaryMessage((String)r, (boolean)true);
        this.sendPacket(bytes, netAddressStr, netPort);
    }

    private void sendFirmware(ServerResponseBinaryFw5 srvRsp, String netAddressStr, int netPort) {
        List transferBlocks = this.prepareTransferBlocks(srvRsp);
        transferBlocks.forEach(block -> this.sendPacket(block, netAddressStr, netPort));
        if (log.isDebugEnabled()) {
            int lastBlockNumber = srvRsp.firstBlock() + transferBlocks.size() - 1;
            log.debug("Data blocks {} - {} ({}) has been sent to {}:{}.", new Object[]{srvRsp.firstBlock(), lastBlockNumber, transferBlocks.size(), netAddressStr, netPort});
        }
    }

    private void sendPacket(byte[] payload, String netAddressStr, int netPort) {
        try {
            InetAddress netAddress = InetAddress.getByName(netAddressStr);
            DatagramPacket responsePacket = new DatagramPacket(payload, payload.length);
            responsePacket.setAddress(netAddress);
            responsePacket.setPort(netPort);
            this.socket.send(responsePacket);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<byte[]> prepareTransferBlocks(ServerResponseBinaryFw5 r) {
        try {
            byte[] data = r.data();
            int pos = 0;
            int blockNumber = r.firstBlock();
            int blockSize = r.blockSize();
            ArrayList<byte[]> result = new ArrayList<byte[]>();
            while (pos < data.length) {
                ByteArrayOutputStream blckPayload = new ByteArrayOutputStream(blockSize + 20);
                blckPayload.write(String.format("PSA%05d;", r.pdmNumber()).getBytes(IntegrationConsts.PDM_5_MESSAGE_CHARSET));
                blckPayload.write(r.firmwareType().getBytes(IntegrationConsts.PDM_5_MESSAGE_CHARSET));
                blckPayload.write(String.format("%04d", blockNumber).getBytes(IntegrationConsts.PDM_5_MESSAGE_CHARSET));
                int startOffset = pos;
                int endOffset = pos + blockSize;
                byte[] payload = Arrays.copyOfRange(data, startOffset, endOffset);
                if (endOffset > data.length) {
                    int fillerStartIndex = blockSize - (endOffset - data.length);
                    Arrays.fill(payload, fillerStartIndex, payload.length, (byte)-1);
                }
                blckPayload.write(payload);
                blckPayload.write(";".getBytes(IntegrationConsts.PDM_5_MESSAGE_CHARSET));
                byte[] payloadWithHeader = blckPayload.toByteArray();
                ByteArrayOutputStream blckWrapper = new ByteArrayOutputStream(payloadWithHeader.length + 10);
                blckWrapper.write(1);
                blckWrapper.write(payloadWithHeader);
                String crc = Crc16Calculator.calculateCrcString((byte[])payloadWithHeader);
                blckWrapper.write(String.format("CRC%s", crc).getBytes(IntegrationConsts.PDM_5_MESSAGE_CHARSET));
                blckWrapper.write(3);
                result.add(blckWrapper.toByteArray());
                pos = endOffset;
                ++blockNumber;
            }
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

