/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.core.integration.PdmMessageProcessingException;
import de.rtb.pcon.core.integration.ServerResponse;
import de.rtb.pcon.core.integration.ServerResponseBinary;
import de.rtb.pcon.core.integration.ServerResponseBinaryFw5;
import de.rtb.pcon.core.integration.ServerResponseJson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;

/*
 * Exception performing whole class analysis ignored.
 */
@NonNull
class Siemens95TcpCodec
implements Deserializer<byte[]>,
Serializer<ServerResponse> {
    private static final Logger log = LoggerFactory.getLogger(Siemens95TcpCodec.class);
    private static final int MAX_MESSAGE_SIZE = 4096;

    Siemens95TcpCodec() {
    }

    protected void checkClosure(int bite) throws IOException {
        if (bite < 0) {
            log.debug("Socket closed during message assembly");
            throw new IOException("Socket closed during message assembly");
        }
    }

    public byte[] deserialize(InputStream inputStream) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(500);
        try {
            byte[] netData;
            int b;
            int totalBytes = 0;
            while ((b = inputStream.read()) != -1) {
                if (++totalBytes > 4096) {
                    throw new PdmMessageProcessingException("Ignoring message because its end was not not found within first 4096 bytes. Message: '" + Siemens95TcpCodec.createStringWithVisibleCharactes((byte[])buffer.toByteArray()));
                }
                if (b == 3) {
                    buffer.write(b);
                    break;
                }
                buffer.write(b);
            }
            if ((netData = buffer.toByteArray()).length == 0) {
                log.trace("Reading from socket is aborted because there are no data");
                throw new SoftEndOfStreamException("No data available in the stream");
            }
            if (netData[netData.length - 1] != 3) {
                throw new PdmMessageProcessingException("End of frame was not found in the message '" + Siemens95TcpCodec.createStringWithVisibleCharactes((byte[])netData, (int)totalBytes, (int)b) + "'");
            }
            int startOfData = ArrayUtils.indexOf((byte[])netData, (byte)1);
            if (startOfData == -1) {
                throw new PdmMessageProcessingException("Start of frame was not found in the message '" + Siemens95TcpCodec.createStringWithVisibleCharactes((byte[])netData) + "'");
            }
            if (startOfData > 0) {
                log.atInfo().setMessage("Removed characters '{}' before start of message '{}'").addArgument(() -> Siemens95TcpCodec.createStringWithVisibleCharactes((byte[])netData, (int)0, (int)startOfData)).addArgument(() -> Siemens95TcpCodec.createStringWithVisibleCharactes((byte[])netData)).log();
            }
            return Arrays.copyOfRange(netData, startOfData + 1, netData.length - 1);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Message from PDM could not been read", e);
        }
    }

    public void serialize(ServerResponse serverResponse, OutputStream outputStream) throws IOException {
        ServerResponse serverResponse2 = serverResponse;
        Objects.requireNonNull(serverResponse2);
        ServerResponse serverResponse3 = serverResponse2;
        int n = 0;
        byte[] binMsg = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ServerResponseJson.class, ServerResponseBinary.class, ServerResponseBinaryFw5.class}, (Object)serverResponse3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ServerResponseJson j = (ServerResponseJson)serverResponse3;
                yield ServerResponseJson.makeBinaryMessage((String)j.toTextPdm7(), (boolean)true);
            }
            case 1 -> {
                ServerResponseBinary b = (ServerResponseBinary)serverResponse3;
                yield b.toBinaryMessage();
            }
            case 2 -> {
                ServerResponseBinaryFw5 f5 = (ServerResponseBinaryFw5)serverResponse3;
                throw new UnsupportedOperationException("Server response of type " + String.valueOf(f5.getClass()) + " is not supported in TCP mode.");
            }
        };
        outputStream.write(binMsg);
    }

    static String createStringWithVisibleCharactes(byte[] bytes, int offset, int lenght) {
        String str = new String(bytes, offset, lenght, StandardCharsets.UTF_8);
        return str.chars().mapToObj(c -> c >= 0 && c <= 32 ? String.format("[0x%02X]", c) : String.valueOf((char)c)).collect(Collectors.joining());
    }

    static String createStringWithVisibleCharactes(byte[] bytes) {
        return Siemens95TcpCodec.createStringWithVisibleCharactes((byte[])bytes, (int)0, (int)bytes.length);
    }
}

