/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.config.DevelopmentProperties;
import de.rtb.pcon.core.integration.PconEntryService;
import de.rtb.pcon.core.integration.PdmInputProperties;
import de.rtb.pcon.core.integration.Siemens95MessageUtils;
import de.rtb.pcon.core.integration.Siemens95TcpCodec;
import de.rtb.pcon.core.integration.UdpServer;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.MessageChannels;
import org.springframework.integration.dsl.MessagingGatewaySpec;
import org.springframework.integration.ip.dsl.AbstractConnectionFactorySpec;
import org.springframework.integration.ip.dsl.Tcp;
import org.springframework.integration.ip.dsl.TcpInboundGatewaySpec;
import org.springframework.integration.ip.dsl.TcpNetServerConnectionFactorySpec;
import org.springframework.messaging.MessageChannel;

@Configuration
class Siemens95IntegrationConfig {
    public static final String TASK_EXECUTOR_S95_ASM = "taskExecutorS95Asm";
    public static final String TASK_EXECUTOR_S95_MAIN = "taskExecutorS95Main";
    private static final String CH_PROCESSING_UDP = "chProcessingUdp";
    private static final String CH_PROCESSING_TCP = "chProcessingTcp";
    private final MessageChannel chUdpResponse = new PublishSubscribeChannel();

    @Bean(value={"taskExecutorS95Asm"})
    AsyncTaskExecutor asmIntegrationTaskExecutor() {
        return new VirtualThreadTaskExecutor("s95-asm-");
    }

    @Bean(value={"taskExecutorS95Main"})
    AsyncTaskExecutor mainIntegrationTaskExecutor() {
        return new VirtualThreadTaskExecutor("pdm-s95-");
    }

    @Bean(name={"errorChannel"})
    MessageChannel errorChannel() {
        return new PublishSubscribeChannel();
    }

    @Bean(name={"chProcessingUdp"})
    MessageChannel chProcessingUdp(@Qualifier(value="taskExecutorS95Main") Executor executor) {
        return (MessageChannel)MessageChannels.executor((Executor)executor).getObject();
    }

    @Bean(name={"chProcessingTcp"})
    MessageChannel chProcessingTcp() {
        return new PublishSubscribeChannel();
    }

    @Bean
    Siemens95TcpCodec siemens95Codec() {
        return new Siemens95TcpCodec();
    }

    @Bean
    IntegrationFlow tcpServer(Siemens95TcpCodec codec, PdmInputProperties prosp, @Qualifier(value="chProcessingTcp") MessageChannel chProcessingTcp, @Qualifier(value="taskExecutorS95Asm") Executor exeAsm, @Qualifier(value="taskExecutorS95Main") Executor exeMain, @Qualifier(value="errorChannel") MessageChannel errorChannel) {
        TcpNetServerConnectionFactorySpec connectionFactory = (TcpNetServerConnectionFactorySpec)((TcpNetServerConnectionFactorySpec)((TcpNetServerConnectionFactorySpec)((TcpNetServerConnectionFactorySpec)Tcp.netServer((int)prosp.getTcpPort()).serializer((Serializer)codec)).deserializer((Deserializer)codec)).taskExecutor(exeMain)).lookupHost(false);
        TcpInboundGatewaySpec tcpGateway = (TcpInboundGatewaySpec)Tcp.inboundGateway((AbstractConnectionFactorySpec)connectionFactory).errorChannel(errorChannel);
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessagingGatewaySpec)tcpGateway).enrichHeaders(h -> h.header("src_proto", (Object)"TCP"))).channel(chProcessingTcp)).get();
    }

    @Bean
    IntegrationFlow processingTcp(Siemens95MessageUtils pdmMessageUtils, PconEntryService pdmControService, DevelopmentProperties devProps, @Qualifier(value="chProcessingTcp") MessageChannel chProcessingTcp) {
        boolean validateHash = !devProps.isDisableCrcValidation();
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)chProcessingTcp).transform(p -> pdmMessageUtils.transformSiemens95ToJson(p, validateHash))).handle((arg_0, arg_1) -> ((PconEntryService)pdmControService).handleRequest(arg_0, arg_1))).get();
    }

    @Bean
    IntegrationFlow udpServerIn(Siemens95TcpCodec codec, PdmInputProperties pdmInProps, @Qualifier(value="taskExecutorS95Main") Executor exeMain, @Qualifier(value="chProcessingUdp") MessageChannel chProcessingUdp, UdpServer udpServer) {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)udpServer.getOutputChannel()).enrichHeaders(h -> h.header("src_proto", (Object)"UDP"))).enrich(h -> h.header("replyChannel", (Object)this.chUdpResponse))).channel(chProcessingUdp)).get();
    }

    @Bean
    IntegrationFlow processingUdp(Siemens95MessageUtils pdmMessageUtils, PconEntryService pdmControService, DevelopmentProperties devProps, @Qualifier(value="chProcessingUdp") MessageChannel chProcessing) {
        boolean validateHash = !devProps.isDisableCrcValidation();
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)chProcessing).transform(p -> pdmMessageUtils.transformSiemens95ToJson(p, validateHash))).handle((arg_0, arg_1) -> ((PconEntryService)pdmControService).handleRequest(arg_0, arg_1))).get();
    }

    @Bean
    IntegrationFlow udpServerOut(Siemens95TcpCodec serializer, UdpServer udpServer, PdmInputProperties pdmInProps) {
        return ((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)this.chUdpResponse).handle(arg_0 -> ((UdpServer)udpServer).sendMessageToPdm(arg_0))).get();
    }

    @Bean
    IntegrationFlow errorFlow(PconEntryService pdmControlEntryService, @Qualifier(value="errorChannel") MessageChannel errorChannel) {
        return ((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)errorChannel).handle((arg_0, arg_1) -> ((PconEntryService)pdmControlEntryService).handleFailure(arg_0, arg_1))).get();
    }
}

