/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.boot_app.ApplicationContextHolder;
import de.rtb.pcon.core.integration.Crc16Calculator;
import de.rtb.pcon.core.integration.IntegrationConsts;
import de.rtb.pcon.core.integration.MnemonicOrderComparator;
import de.rtb.pcon.core.integration.ServerResponse;
import de.rtb.pcon.core.integration.Siemens95MessageUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerResponseJson
implements ServerResponse {
    private static final Logger log = LoggerFactory.getLogger(ServerResponseJson.class);
    private final ObjectNode root;
    private final MnemonicOrderComparator mnemonicComparator;
    private final Siemens95MessageUtils msgUtils;
    private final ObjectMapper objectMapper = (ObjectMapper)ApplicationContextHolder.getBean(ObjectMapper.class);

    public ServerResponseJson() {
        this.msgUtils = (Siemens95MessageUtils)ApplicationContextHolder.getBean(Siemens95MessageUtils.class);
        this.mnemonicComparator = new MnemonicOrderComparator();
        this.root = this.objectMapper.createObjectNode();
    }

    public void append(String name) {
        this.append(name, (Object)"");
    }

    public void append(String name, @Nullable Object value) {
        Object val = value != null ? value : "";
        JsonNode oldValue = this.root.get(name);
        if (oldValue != null) {
            log.atWarn().setMessage("Mnemonic {} replaced. Value changed from {} to {}.").addArgument((Object)name).addArgument(() -> ((JsonNode)oldValue).asText()).addArgument(val).log();
        }
        this.root.set(name, this.objectMapper.valueToTree(value));
    }

    public String toString() {
        return this.root.toString();
    }

    public String toTextPdm7() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.root.fields(), 0), false).sorted((a, b) -> this.mnemonicComparator.compare((String)a.getKey(), (String)b.getKey())).map(arg_0 -> ((Siemens95MessageUtils)this.msgUtils).mapToMnemonic(arg_0)).collect(Collectors.joining(";", "", ";"));
    }

    public String toTextPdm5() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.root.fields(), 0), false).sorted((a, b) -> this.mnemonicComparator.compare((String)a.getKey(), (String)b.getKey())).map(arg_0 -> ((Siemens95MessageUtils)this.msgUtils).mapToMnemonic(arg_0)).collect(Collectors.joining(";", "", ";"));
    }

    public ObjectNode toJsonNode() {
        return this.root;
    }

    public static byte[] makeBinaryMessage(String textMessage, boolean addFrameMarkers) {
        byte[] msgBytes = textMessage.getBytes(IntegrationConsts.PDM_MESSAGE_CHARSET);
        Crc16Calculator crcCalculator = new Crc16Calculator();
        crcCalculator.addBytes(msgBytes);
        int crc = crcCalculator.getCrc();
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            if (addFrameMarkers) {
                bytes.write(1);
            }
            bytes.write(msgBytes);
            bytes.write("CRC".getBytes(IntegrationConsts.PDM_MESSAGE_CHARSET));
            bytes.write(Crc16Calculator.numberCrcToString((int)crc).getBytes(IntegrationConsts.PDM_MESSAGE_CHARSET));
            if (addFrameMarkers) {
                bytes.write(3);
            }
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

