/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.core.integration.ServerResponse;
import org.apache.commons.io.FileUtils;

public record ServerResponseBinaryFw5(byte[] data, Integer pdmNumber, Integer firstBlock, Integer blockSize, String firmwareType) implements ServerResponse
{
    private final byte[] data;
    private final Integer pdmNumber;
    private final Integer firstBlock;
    private final Integer blockSize;
    private final String firmwareType;

    public ServerResponseBinaryFw5(byte[] data, Integer pdmNumber, Integer firstBlock, Integer blockSize, String firmwareType) {
        this.data = data;
        this.pdmNumber = pdmNumber;
        this.firstBlock = firstBlock;
        this.blockSize = blockSize;
        this.firmwareType = firmwareType;
    }

    public byte[] toBinaryMessage() {
        return this.data;
    }

    @Override
    public String toString() {
        int nrOfBlocks = Math.ceilDiv(this.data.length, (int)this.blockSize);
        int lastBlockNumber = this.firstBlock + nrOfBlocks - 1;
        int numberOfBlocks = this.data.length / this.blockSize;
        return "Firmware 5 (" + this.firmwareType + ") data blocks " + this.firstBlock + " - " + lastBlockNumber + " (" + numberOfBlocks + "), " + FileUtils.byteCountToDisplaySize((long)this.data.length) + " (" + this.data.length + " B) long";
    }

    public byte[] data() {
        return this.data;
    }

    public Integer pdmNumber() {
        return this.pdmNumber;
    }

    public Integer firstBlock() {
        return this.firstBlock;
    }

    public Integer blockSize() {
        return this.blockSize;
    }

    public String firmwareType() {
        return this.firmwareType;
    }
}

