/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import com.fasterxml.jackson.databind.JsonNode;
import de.rtb.pcon.core.integration.MultiContenSiemens95Message;
import de.rtb.pcon.core.integration.PdmMessageProcessingException;
import de.rtb.pcon.core.integration.ServerResponse;
import de.rtb.pcon.core.integration.ServerResponseJson;
import de.rtb.pcon.core.logging.PdmThreadLocalMarker;
import de.rtb.pcon.core.services.pdm_in.MessageParserService;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Service;

@Service
class PconEntryService {
    private static final Logger log = LoggerFactory.getLogger(PconEntryService.class);
    private final MessageParserService messageParserService;

    PconEntryService(MessageParserService messageParserService) {
        this.messageParserService = messageParserService;
    }

    Message<? extends ServerResponse> handleRequest(MultiContenSiemens95Message message, MessageHeaders headers) {
        long execStart = System.currentTimeMillis();
        int pdmNr = message.json().get("PSA").asInt();
        Optional<Integer> gacNr = Optional.ofNullable(message.json().get("GAC")).map(JsonNode::asInt);
        Optional<String> cpuNr = Optional.ofNullable(message.json().get("PID")).map(JsonNode::asText);
        PdmThreadLocalMarker threadMarker = PdmThreadLocalMarker.instance();
        threadMarker.setPdm(pdmNr, gacNr, cpuNr);
        String ipAddress = (String)headers.get((Object)"ip_address", String.class);
        Integer ipPort = (Integer)headers.get((Object)"ip_port", Integer.class);
        String ipProtocol = (String)headers.get((Object)"src_proto", String.class);
        log.atInfo().setMessage(">>> [{}, {}] {}CRC{}").addArgument((Object)ipProtocol).addArgument(() -> ipAddress + (String)(ipPort != null ? ":" + ipPort : "")).addArgument((Object)message.text()).addArgument((Object)message.crc()).log();
        boolean isCrcOk = Optional.ofNullable(message.json().get("validCrc")).map(x -> x.asBoolean()).orElseThrow(() -> new PdmMessageProcessingException("Flag to indicate CRC validity is not present"));
        ServerResponse serverResponse = null;
        if (isCrcOk) {
            String srcProtocol = (String)headers.get((Object)"src_proto");
            serverResponse = this.messageParserService.processMessage(message.json(), srcProtocol);
        } else {
            ServerResponseJson serverResponseNok = new ServerResponseJson();
            serverResponseNok.append("PSA", (Object)pdmNr);
            gacNr.ifPresent(g -> serverResponseNok.append("GAC", g));
            serverResponseNok.append("NOK");
            serverResponse = serverResponseNok;
        }
        long execTime = System.currentTimeMillis() - execStart;
        ServerResponse finalServerResponse = serverResponse;
        log.atInfo().setMessage("<<< [{}]: {}").addArgument(() -> String.format("%3d", execTime)).addArgument(() -> this.formatServerResponseForLog(finalServerResponse, ipProtocol)).log();
        return ((MessageBuilder)MessageBuilder.withPayload((Object)finalServerResponse).copyHeaders((Map)headers)).build();
    }

    private String formatServerResponseForLog(ServerResponse srvResponse, String ipProtocol) {
        ServerResponse serverResponse = srvResponse;
        Objects.requireNonNull(serverResponse);
        ServerResponse serverResponse2 = serverResponse;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ServerResponseJson.class}, (Object)serverResponse2, n)) {
            case 0 -> {
                ServerResponseJson j = (ServerResponseJson)serverResponse2;
                if ("TCP".compareToIgnoreCase(ipProtocol) == 0) {
                    yield j.toTextPdm7();
                }
                yield j.toTextPdm5();
            }
            default -> srvResponse.toString();
        };
    }

    Message<ServerResponseJson> handleFailure(MessagingException exception, MessageHeaders headers) {
        log.error("Error occurred in processing of PDM request: " + exception.getMessage(), exception.getCause());
        Message failedMessage = exception.getFailedMessage();
        MessageHeaders responseHeaders = failedMessage != null ? failedMessage.getHeaders() : headers;
        ServerResponseJson payload = new ServerResponseJson();
        Throwable causeException = exception.getCause();
        if (causeException instanceof PdmMessageProcessingException) {
            PdmMessageProcessingException ex = (PdmMessageProcessingException)causeException;
            ex.getResponseMap().entrySet().forEach(e -> payload.append((String)e.getKey(), e.getValue()));
        }
        log.atInfo().setMessage("<<< [XXX]: {}").addArgument(() -> ((ServerResponseJson)payload).toString()).log();
        String causeMessage = Optional.ofNullable(exception.getCause()).map(t -> t.getMessage()).orElseGet(() -> exception.getMessage());
        payload.append("ERM", (Object)causeMessage);
        return ((MessageBuilder)MessageBuilder.withPayload((Object)payload).copyHeaders((Map)responseHeaders)).build();
    }
}

