/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.hw_components;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.core.hw_components.DeviceReport;
import de.rtb.pcon.core.hw_components.DeviceReportMetaInf;
import de.rtb.pcon.core.hw_components.HardwareInfoParser;
import de.rtb.pcon.core.hw_components.PdmVersion;
import de.rtb.pcon.core.services.pdm_in.MessageParserHelper;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.PdmHwDevice;
import de.rtb.pcon.model.PdmHwDevicePart;
import de.rtb.pcon.model.download.DownloadTarget;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
final class HardwareInfoParser {
    private static final Logger log = LoggerFactory.getLogger(HardwareInfoParser.class);
    private static final Pattern PAT_MDL2014_CONFIG_SW_FILE_VER = Pattern.compile("V(?<format>\\d{1}\\.\\d{2})");
    private static final Pattern PAT_MDL2014_CONFIG_SW_CRC = Pattern.compile("crc(?<crc>[a-f0-9]+)", 2);
    private static final Pattern PAT_MDL2014_CONFIG_SW_DATE = Pattern.compile("(?<year>\\d+)\\.(?<month>\\d+)\\.(?<day>\\d+)\\s(?<hour>\\d+):(?<minute>\\d+)");
    private static final Pattern PAT_MDL2014_MAIN_BOARD_MEM = Pattern.compile("(?<ram>\\d+)MB/(?<rom>\\d+)MB");
    private static final Pattern PAT_VERSION = Pattern.compile("\\d(\\.\\d+)*");
    private static final String JF_COMPONENT_PDM = "pdm";
    private static final String JF_COMPONENT_MODEM = "modem";
    private static final String JF_COMPONENT_PRINTER_1 = "printer_1";
    private static final String JF_COMPONENT_CARD_READER_1 = "card_reader_1";
    private static final String JF_NAME = "name";
    private static final String JF_VERSION = "ver";
    private static final String JF_SERIAL_NUMBER = "sn";
    private static final String JF_UPGRADABLE = "up";
    private ObjectMapper pdmObjectMapper;
    private ObjectMapper stdObjectMapper;

    HardwareInfoParser(ObjectMapper pdmObjectMapper, ObjectMapper stdObjectMapper) {
        this.pdmObjectMapper = pdmObjectMapper;
        this.stdObjectMapper = stdObjectMapper;
    }

    public Optional<DeviceReport> parseV5(PdmMessageDto m) {
        LinkedList deviceList = new LinkedList();
        PdmVersion version = PdmVersion.fromString((String)m.getVer());
        HwSw hwSw = new HwSw("PDM" + version.getMajor() + "_" + String.valueOf(version.getPdm5Variant()), version.toString());
        PdmHwDevice devPdm = this.addDevice2014(deviceList, hwSw, DownloadTarget.PDM, "pdm", PdmHwDevicePart.DEVICE);
        if (StringUtils.isNotBlank((CharSequence)m.getPid())) {
            devPdm.setSerialNumber(StringUtils.trim((String)m.getPid()));
        }
        this.addDevice2014(deviceList, new HwSw("PDM5", "?"), DownloadTarget.CONFIG, "pdm", PdmHwDevicePart.CONFIG);
        if (!StringUtils.isBlank((CharSequence)m.getVem())) {
            this.addDevice2014(deviceList, this.v5ReadModem(m.getVem()), DownloadTarget.MODEM, "modem", PdmHwDevicePart.DEVICE);
        }
        if (StringUtils.isNotBlank((CharSequence)m.getVep())) {
            this.addDevice2014(deviceList, this.v5ReadPrinter(m.getVep()), DownloadTarget.PRINTER_1, "printer_1", PdmHwDevicePart.DEVICE);
        }
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{m.getArv(), m.getVeh()})) {
            if (StringUtils.isNotBlank((CharSequence)m.getArv())) {
                this.addDevice2014(deviceList, this.v5ReadCardReaderArthema(m.getArv()), DownloadTarget.CARD_READER_1, "card_reader_1", PdmHwDevicePart.DEVICE);
            } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{m.getVeh()})) {
                this.addDevice2014(deviceList, this.v5ReadCardReaderMcs(m.getVeh()), DownloadTarget.CARD_READER_1, "card_reader_1", PdmHwDevicePart.DEVICE);
            }
        }
        if (deviceList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DeviceReport(deviceList, DeviceReportMetaInf.defaultValue()));
    }

    Optional<DeviceReport> parseMdl2020(ObjectNode mdl) {
        Optional<DeviceReportMetaInf> metaData = Optional.empty();
        try {
            LinkedList<PdmHwDevice> deviceList = new LinkedList<PdmHwDevice>();
            ObjectNode rootNode = mdl;
            Iterator devicesIterator = rootNode.fields();
            while (devicesIterator.hasNext()) {
                Map.Entry deviceNodeEntry = (Map.Entry)devicesIterator.next();
                String deviceName = (String)deviceNodeEntry.getKey();
                if (DeviceReportMetaInf.NODE_NAME.equals(deviceName)) {
                    DeviceReportMetaInf meta = (DeviceReportMetaInf)this.pdmObjectMapper.treeToValue((TreeNode)deviceNodeEntry.getValue(), DeviceReportMetaInf.class);
                    metaData = Optional.of(meta);
                    continue;
                }
                Iterator partsIterator = ((JsonNode)deviceNodeEntry.getValue()).fields();
                while (partsIterator.hasNext()) {
                    JsonNode jfUpdatable;
                    Map.Entry partNodeEntry = (Map.Entry)partsIterator.next();
                    String partName = (String)partNodeEntry.getKey();
                    JsonNode partNodeVal = (JsonNode)partNodeEntry.getValue();
                    PdmHwDevice device = new PdmHwDevice();
                    device.setDeviceName(StringUtils.defaultString((String)deviceName));
                    device.setPart(PdmHwDevicePart.formJsonName((String)partName));
                    DownloadTarget.formHwReport((String)device.getDeviceName(), (PdmHwDevicePart)device.getPart()).ifPresent(t -> device.setTarget(t));
                    if (Objects.nonNull(partNodeVal.get("name"))) {
                        device.setModel(partNodeVal.get("name").asText());
                    }
                    if (Objects.nonNull(partNodeVal.get("ver"))) {
                        device.setVersion(partNodeVal.get("ver").asText());
                    }
                    if (Objects.nonNull(partNodeVal.get("sn"))) {
                        device.setSerialNumber(partNodeVal.get("sn").asText());
                    }
                    if (Objects.nonNull(jfUpdatable = partNodeVal.get("up"))) {
                        device.setUpdatable(jfUpdatable.asBoolean());
                    }
                    device.setProperties(this.stdObjectMapper.writeValueAsString((Object)partNodeVal));
                    deviceList.add(device);
                }
            }
            return Optional.of(new DeviceReport(deviceList, metaData.orElseGet(DeviceReportMetaInf::defaultValue)));
        }
        catch (JsonProcessingException e) {
            log.error("MDL mnemonic can not be parsed", (Throwable)e);
            return Optional.empty();
        }
    }

    private PdmHwDevice addDevice2014(List<PdmHwDevice> result, HwSw hwSw, DownloadTarget target, String devName, PdmHwDevicePart part) {
        if (hwSw != null) {
            PdmHwDevice dev = new PdmHwDevice();
            dev.setDeviceName(devName);
            dev.setPart(part);
            dev.setModel(hwSw.hw);
            dev.setVersion(hwSw.sw);
            dev.setTarget(target);
            result.add(dev);
            return dev;
        }
        return null;
    }

    ObjectNode mdl2014ReadConfigElement(HwSw hwSw) {
        ObjectNode node = this.pdmObjectMapper.createObjectNode();
        if (hwSw.hw.startsWith("V") && hwSw.sw.startsWith("CFG")) {
            Matcher mCreatorVersion;
            Matcher mDate;
            Matcher mCrc = PAT_MDL2014_CONFIG_SW_CRC.matcher(hwSw.hw);
            if (mCrc.find()) {
                node.put("crc", mCrc.group("crc").toLowerCase());
            }
            if ((mDate = PAT_MDL2014_CONFIG_SW_DATE.matcher(hwSw.hw)).find()) {
                LocalDateTime dateTime = LocalDateTime.of(Integer.parseInt(mDate.group("year")), Integer.parseInt(mDate.group("month")), Integer.parseInt(mDate.group("day")), Integer.parseInt(mDate.group("hour")), Integer.parseInt(mDate.group("minute")));
                node.put("ver", dateTime.toString());
            }
            node.put("name", "PDM7");
            Matcher mConfigVersion = PAT_MDL2014_CONFIG_SW_FILE_VER.matcher(hwSw.hw);
            if (mConfigVersion.find()) {
                node.put("format", mConfigVersion.group("format"));
            }
            if ((mCreatorVersion = PAT_VERSION.matcher(hwSw.sw)).find()) {
                node.put("creator", mCreatorVersion.group());
            }
        } else {
            node.put("name", hwSw.hw);
            node.put("ver", hwSw.sw);
        }
        return node;
    }

    ObjectNode mdl2014ReadCpuElement(HwSw mainBoard) {
        Matcher mMemory;
        Objects.requireNonNull(mainBoard);
        ObjectNode node = this.pdmObjectMapper.createObjectNode();
        node.put("sn", mainBoard.sw);
        String[] mainBoardHwParts = StringUtils.split((String)mainBoard.hw);
        if (mainBoardHwParts.length > 0) {
            node.put("name", mainBoardHwParts[0]);
        }
        if (mainBoardHwParts.length > 1 && (mMemory = PAT_MDL2014_MAIN_BOARD_MEM.matcher(mainBoardHwParts[1])).find()) {
            int bytesInMb = 0x100000;
            node.put("ram", Integer.parseInt(mMemory.group("ram")) * bytesInMb);
            node.put("rom", Integer.parseInt(mMemory.group("rom")) * bytesInMb);
        }
        return node;
    }

    ObjectNode mdl2014ReadStandardElement(HwSw hwSw) {
        ObjectNode node = this.pdmObjectMapper.createObjectNode();
        node.put("name", hwSw.hw);
        node.put("ver", hwSw.sw);
        return node;
    }

    private HwSw v5ReadModem(String vem) {
        String ver = StringUtils.defaultString((String)vem).trim();
        if (!ver.isEmpty()) {
            String hwType = "?";
            if (ver.startsWith("V3.")) {
                hwType = "MCS4157";
            } else if (ver.startsWith("V4.")) {
                hwType = "MCS4162";
            } else if (ver.startsWith("001")) {
                hwType = "MCS6960";
            }
            return new HwSw(hwType, ver);
        }
        return null;
    }

    private HwSw v5ReadPrinter(String vep) {
        String ver = StringUtils.defaultString((String)vep).trim();
        String hwType = "?";
        if (ver.startsWith("8") || ver.startsWith("9")) {
            hwType = "MCS4034";
        } else if (ver.startsWith("B")) {
            hwType = "MCS4036";
        }
        return new HwSw(hwType, ver);
    }

    private HwSw v5ReadCardReaderArthema(String arv) {
        String hwType = "?";
        String ver = StringUtils.defaultString((String)arv).trim();
        if ("0134".equals(ver)) {
            hwType = "AVT.compact";
        }
        return new HwSw(hwType, ver);
    }

    private HwSw v5ReadCardReaderMcs(String veh) {
        String ver = StringUtils.defaultString((String)veh).trim();
        if (ver.isEmpty() || MessageParserHelper.PATTERN_ONLY_ZEROES.matcher(ver).matches()) {
            return new HwSw("?", "?");
        }
        return new HwSw("MCS_626", ver);
    }

    static void printNode(JsonNode node, int level) {
        Iterator nodeIterator = node.fields();
        String spacing = StringUtils.repeat((char)' ', (int)level);
        while (nodeIterator.hasNext()) {
            Map.Entry x = (Map.Entry)nodeIterator.next();
            String key = (String)x.getKey();
            JsonNode val = (JsonNode)x.getValue();
            if (val.isObject()) {
                log.info("JSON: {}{}:", (Object)spacing, (Object)key);
                HardwareInfoParser.printNode((JsonNode)val, (int)(level + 2));
                continue;
            }
            if (!log.isInfoEnabled()) continue;
            log.info("JSON: {}{}: {}", new Object[]{spacing, key, val.toPrettyString()});
        }
    }
}

