/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.gdpr;

import de.rtb.pcon.core.gdpr.GdprRepository;
import de.rtb.pcon.model.Area;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
class GdprWorkerService {
    private static final Logger log = LoggerFactory.getLogger(GdprWorkerService.class);
    @Autowired
    private GdprRepository gdprRepo;

    GdprWorkerService() {
    }

    @Transactional
    public void evictGdprRelatedData(Area area) {
        int nrOfDeletedLpns;
        int nrOfGdprEntries;
        Optional lastCleanup = this.gdprRepo.findLastCleanupForArea(area);
        if (lastCleanup.isEmpty() && (nrOfGdprEntries = this.gdprRepo.countGdprDataForArea(area)) == 0) {
            this.gdprRepo.insertDefaultGdprContent(area.getId());
            log.atDebug().setMessage("Created new GDPR entry for {}").addArgument(() -> LoggerUtils.log((Area)area)).log();
        }
        Optional<OffsetDateTime> cleanupStart = lastCleanup.map(OffsetDateTime::parse);
        OffsetDateTime cleanupEnd = OffsetDateTime.now().minusDays(area.getCleanLpnAfterDays().intValue()).truncatedTo(ChronoUnit.DAYS);
        if (cleanupStart.isPresent()) {
            nrOfDeletedLpns = this.gdprRepo.deleteLicensePlatesBetweeen(area, cleanupStart.get(), cleanupEnd);
        } else {
            OffsetDateTime defaultCleanupStart = OffsetDateTime.of(LocalDate.of(2000, 1, 1), LocalTime.of(0, 0), ZoneOffset.UTC);
            nrOfDeletedLpns = this.gdprRepo.deleteLicensePlatesBetweeen(area, defaultCleanupStart, cleanupEnd);
        }
        log.atInfo().setMessage("Cleaned GDPR data of {} from {} to {}, removed {} car license plates. ").addArgument(() -> LoggerUtils.log((Area)area)).addArgument(cleanupStart).addArgument((Object)cleanupEnd).addArgument((Object)nrOfDeletedLpns).log();
        this.gdprRepo.updateLastCleanup(area, cleanupEnd);
    }
}

