/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.gdpr;

import de.rtb.pcon.core.gdpr.GdprRepository;
import de.rtb.pcon.core.gdpr.GdprWorkerService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
class GdprSchedulerService {
    private static final Logger log = LoggerFactory.getLogger(GdprSchedulerService.class);
    @Autowired
    private GdprWorkerService gdprWorkerService;
    @Autowired
    private GdprRepository gdprRepo;

    GdprSchedulerService() {
    }

    @Scheduled(cron="20 17 3 * * ?")
    void evictGdprRelatedData() {
        List areasToClean = this.gdprRepo.listCleanableAreas();
        if (!areasToClean.isEmpty()) {
            log.info("Starting GDPR clean-up, found {} relevant areas.", (Object)areasToClean.size());
        }
        areasToClean.forEach(arg_0 -> ((GdprWorkerService)this.gdprWorkerService).evictGdprRelatedData(arg_0));
    }
}

