/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.gdpr;

import de.rtb.pcon.model.Area;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Param;

interface GdprRepository
extends Repository<Area, Integer> {
    @Query(value="UPDATE PaymentTransaction SET lpn = null WHERE id.pdm.zone.area = :area AND id.pdmTime >= :from AND id.pdmTime < :to AND lpn IS NOT NULL")
    @Modifying
    public int deleteLicensePlatesBetweeen(@Param(value="area") Area var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3);

    @Query(value="FROM Area WHERE cleanLpnAfterDays IS NOT NULL")
    public List<Area> listCleanableAreas();

    @Query(value="SELECT \"value\"->>'lpnCleanup' FROM control.cache_permanent WHERE \"type\" = 'GDPR_EVICTION' AND \"value\"->>'area' = ?#{[0].getId().toString()}", nativeQuery=true)
    public Optional<String> findLastCleanupForArea(Area var1);

    @Modifying
    @Query(value="UPDATE control.cache_permanent SET \"value\" = \"value\" || jsonb_build_object('lpnCleanup', ?#{[1].toString()}) WHERE \"type\" = 'GDPR_EVICTION' AND value->>'area' = ?#{[0].getId().toString()}", nativeQuery=true)
    public void updateLastCleanup(Area var1, OffsetDateTime var2);

    @Modifying
    @Query(value="INSERT INTO control.cache_permanent(\"type\", \"value\") VALUES('GDPR_EVICTION',jsonb_build_object('area', ?1))", nativeQuery=true)
    public void insertDefaultGdprContent(Integer var1);

    @Query(value="SELECT count(*) FROM control.cache_permanent WHERE \"type\" = 'GDPR_EVICTION' AND \"value\"->>'area' = ?#{[0].getId().toString()}", nativeQuery=true)
    public int countGdprDataForArea(Area var1);
}

