/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download.ui.plan;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.core.fw_download.ui.plan.UiUpdatePlanEditable;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.download.DownloadStatus;
import de.rtb.pcon.ui.controllers.model.UiUser;
import de.rtb.pcontrol.utils.DateTimeUtils;
import jakarta.persistence.Tuple;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class UiUpdatePlanProgress
extends UiUpdatePlanEditable {
    private int id;
    private LocalDateTime modifiedAt;
    private UiUser modifiedBy;
    private Map<DownloadStatus, Long> progress;

    public UiUpdatePlanProgress(DownloadPlan dwp, ZoneId timeZone, List<Tuple> progressData) {
        super(dwp, timeZone);
        Map<DownloadStatus, Long> progressMap;
        this.id = dwp.getId();
        this.modifiedAt = DateTimeUtils.toLocalDateTime((OffsetDateTime)dwp.getModifiedAt(), (ZoneId)timeZone);
        this.modifiedBy = dwp.getModifiedBy() != null ? new UiUser(dwp.getModifiedBy()) : null;
        this.progress = progressMap = progressData.stream().filter(x -> ((Integer)x.get(0, Integer.class)).equals(dwp.getId())).collect(Collectors.toMap(x -> (DownloadStatus)x.get(1, DownloadStatus.class), x -> (Long)x.get(2, Long.class)));
    }

    public UiUpdatePlanProgress(DownloadPlan dwp, ZoneId timeZone) {
        super(dwp, timeZone);
        this.id = dwp.getId();
        this.modifiedAt = DateTimeUtils.toLocalDateTime((OffsetDateTime)dwp.getModifiedAt(), (ZoneId)timeZone);
        this.modifiedBy = dwp.getModifiedBy() != null ? new UiUser(dwp.getModifiedBy()) : null;
        this.progress = dwp.getEntries().stream().collect(Collectors.groupingBy(DownloadEntry::getStatus, Collectors.counting()));
    }

    @JsonProperty(value="progress")
    public Map<Integer, Long> getProgressJson() {
        return this.progress.entrySet().stream().collect(Collectors.toMap(e -> ((DownloadStatus)e.getKey()).ordinal(), Map.Entry::getValue));
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public LocalDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(LocalDateTime createdAt) {
        this.modifiedAt = createdAt;
    }

    public UiUser getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UiUser modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Map<DownloadStatus, Long> getProgress() {
        return this.progress;
    }

    public void setProgress(Map<DownloadStatus, Long> progress) {
        this.progress = progress;
    }
}

