/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download.ui.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.core.fw_download.ui.plan.UiSwTree;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.download.DeviceType;
import de.rtb.pcon.model.download.SoftwareDescription;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class UiSwTree {
    @JsonIgnore
    final Integer areaId;
    private DeviceType type;
    private List<UiSwTreeModel> models;

    public UiSwTree(DeviceType deviceType, List<SoftwareDescription> descs, Area area) {
        this.type = deviceType;
        this.areaId = Optional.ofNullable(area).map(Area::getId).orElse(null);
        Map<String, List<SoftwareDescription>> modelMap = descs.stream().collect(Collectors.groupingBy(SoftwareDescription::getModel));
        this.models = modelMap.entrySet().stream().map(x$0 -> new UiSwTreeModel(this, x$0)).collect(Collectors.toList());
    }

    @JsonProperty(value="type")
    public int getTypeJson() {
        return this.type.ordinal();
    }

    public DeviceType getType() {
        return this.type;
    }

    public void setType(DeviceType type) {
        this.type = type;
    }

    public List<UiSwTreeModel> getModels() {
        return this.models;
    }

    public void setModels(List<UiSwTreeModel> models) {
        this.models = models;
    }
}

