/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download.ui.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.core.fw_download.ui.file.UiSoftwareDerscriptionEditable;
import de.rtb.pcon.model.download.DeviceType;
import de.rtb.pcon.model.download.SoftwareDescription;
import de.rtb.pcon.ui.controllers.model.UiUser;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;

class UiSoftwareDescription
extends UiSoftwareDerscriptionEditable {
    private int id;
    private Integer area;
    private UiUser author;
    private LocalDateTime uploadedAt;
    private DeviceType deviceType;
    private String deviceModel;
    private String fileName;
    private boolean inUse;

    public UiSoftwareDescription() {
    }

    public UiSoftwareDescription(SoftwareDescription swd, ZoneId timeZoneId, boolean inUse) {
        super(swd);
        this.id = swd.getId();
        this.area = swd.getArea() != null ? swd.getArea().getId() : null;
        this.author = swd.getAuthor() != null ? new UiUser(swd.getAuthor()) : null;
        this.uploadedAt = DateTimeUtils.toLocalDateTime((OffsetDateTime)swd.getTimeCreated(), (ZoneId)timeZoneId);
        this.deviceType = swd.getDeviceType();
        this.deviceModel = swd.getModel();
        this.fileName = swd.getFileName();
        this.inUse = inUse;
    }

    @JsonProperty(value="deviceType")
    public int getDeviceTypeJson() {
        return this.deviceType.ordinal();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Integer getArea() {
        return this.area;
    }

    public void setArea(Integer area) {
        this.area = area;
    }

    public UiUser getAuthor() {
        return this.author;
    }

    public void setAuthor(UiUser author) {
        this.author = author;
    }

    public LocalDateTime getUploadedAt() {
        return this.uploadedAt;
    }

    public void setUploadedAt(LocalDateTime uploadedAt) {
        this.uploadedAt = uploadedAt;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }
}

