/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download.ui.file;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.download.DeviceType;
import de.rtb.pcon.model.download.SoftwareDescription;
import de.rtb.pcon.model.download.SoftwareDescription_;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import org.springframework.data.jpa.domain.Specification;

final class FirmwareDownloadSpecifications {
    private FirmwareDownloadSpecifications() {
    }

    public static Specification<SoftwareDescription> hasArea(Area area) {
        return (Specification & Serializable)(root, query, builder) -> builder.equal((Expression)root.get(SoftwareDescription_.area), (Object)area);
    }

    public static Specification<SoftwareDescription> isAreaNull() {
        return (Specification & Serializable)(root, query, builder) -> builder.isNull((Expression)root.get(SoftwareDescription_.area));
    }

    public static Specification<SoftwareDescription> isVisible() {
        return (Specification & Serializable)(root, query, builder) -> builder.isTrue((Expression)root.get(SoftwareDescription_.visible));
    }

    public static Specification<SoftwareDescription> isHidden() {
        return (Specification & Serializable)(root, query, builder) -> builder.isFalse((Expression)root.get(SoftwareDescription_.visible));
    }

    public static Specification<SoftwareDescription> isDeviceType(DeviceType deviceType) {
        return (Specification & Serializable)(root, query, builder) -> builder.equal((Expression)root.get(SoftwareDescription_.deviceType), (Object)deviceType);
    }

    public static Specification<SoftwareDescription> containsText(String text) {
        return (Specification & Serializable)(root, query, builder) -> {
            Predicate pName = builder.like(builder.lower((Expression)root.get(SoftwareDescription_.name)), "%" + text.toLowerCase() + "%");
            Predicate pNote = builder.like(builder.lower((Expression)root.get(SoftwareDescription_.note)), "%" + text.toLowerCase() + "%");
            Predicate pVersion = builder.like(builder.lower((Expression)root.get(SoftwareDescription_.version)), "%" + text.toLowerCase() + "%");
            return builder.or(new Predicate[]{pName, pNote, pVersion});
        };
    }
}

