/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.remote_data_acces;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcontrol.utils.DateTimeUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;

@Schema(name="Status", description="Status message generated by PDM.")
class ExportedStatusMessageDao {
    @Schema(description="Id of PDM which generated the stuatus")
    @JacksonXmlProperty(isAttribute=true, localName="pdm")
    private Integer pdmId;
    @Schema(description="Tracer number; it can be null for records inserted by PDM.control")
    @JacksonXmlProperty(isAttribute=true)
    private Integer tracer;
    @Schema(description="Time when event was created (got form PDM)")
    @JacksonXmlProperty(isAttribute=true)
    private LocalDateTime pdmTime;
    @Schema(description="Time when event was received by server")
    @JacksonXmlProperty(isAttribute=true)
    private LocalDateTime serverTime;
    @Schema(description="Status message number")
    @JacksonXmlText
    private int number;

    public ExportedStatusMessageDao(StatusMessage sm, ZoneId timeZone) {
        this.pdmId = sm.getPdm().getId();
        this.tracer = sm.getTracer();
        this.pdmTime = DateTimeUtils.toLocalDateTime((OffsetDateTime)sm.getPdmTime(), (ZoneId)timeZone);
        this.serverTime = DateTimeUtils.toLocalDateTime((OffsetDateTime)sm.getServerTime(), (ZoneId)timeZone);
        this.number = sm.getMessageConfig().getNumber().shortValue();
    }

    public Integer getTracer() {
        return this.tracer;
    }

    public LocalDateTime getPdmTime() {
        return this.pdmTime;
    }

    public LocalDateTime getServerTime() {
        return this.serverTime;
    }

    public int getNumber() {
        return this.number;
    }
}

