/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.remote_data_acces;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;

@Schema(name="ContinuationTokenSearchResponse", description="Finds continuation token for provided date. It returns first token after provided date.")
@JacksonXmlRootElement(localName="continuationTokenSearch")
class ExportedDateToTokenDao {
    @Schema(description="Requested local date and time were to search from.")
    @JsonProperty(value="dtRequest")
    private LocalDateTime dtRequested;
    @Schema(description="Real date and time belonging to found token.")
    @JsonProperty(value="dtFound")
    private LocalDateTime dtFound;
    @Schema(description="Continuation token to be used for next request to get entries after this date.")
    private Long continuationToken;

    public ExportedDateToTokenDao(LocalDateTime dtRequested) {
        this.dtRequested = dtRequested;
    }

    public ExportedDateToTokenDao(LocalDateTime dtRequested, LocalDateTime dtFound, Long continuationToken) {
        this.dtRequested = dtRequested;
        this.dtFound = dtFound;
        this.continuationToken = continuationToken;
    }

    public LocalDateTime getDtRequested() {
        return this.dtRequested;
    }

    public LocalDateTime getDtFound() {
        return this.dtFound;
    }

    public Long getContinuationToken() {
        return this.continuationToken;
    }
}

