/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.v1;

import de.rtb.pcon.api.enforcement.v1.dao.LpnAndParkTimeProjection;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentTransactionId;
import de.rtb.pcon.model.zone.Zone;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Param;

interface EnforcementRepositoryV1
extends Repository<PaymentTransaction, PaymentTransactionId> {
    @Query(value="SELECT pt.lpn as lpn, MAX(pt.parkEndTime) as parkEnd\nFROM #{#entityName} pt\nWHERE\n  pt.id.pdm.zone = :zone\n  AND pt.id.pdm.zone.enforcementMode = de.rtb.pcon.model.zone.EnforcementMode.LPN\n  AND pt.paymentReason IN (:paymentReasons)\n  AND UPPER(pt.lpn) LIKE UPPER(:lpn)\n  AND pt.id.pdmTime > :searchStart\nGROUP BY pt.lpn\nORDER BY MAX(pt.parkEndTime) ASC")
    public List<LpnAndParkTimeProjection> recentLicensePlates(@Param(value="zone") Zone var1, @Param(value="paymentReasons") Collection<PaymentReason> var2, @Param(value="lpn") String var3, @Param(value="searchStart") OffsetDateTime var4, Pageable var5);

    @Query(value="FROM #{#entityName} pt\nWHERE\n  pt.id.pdm.zone = :zone\n  AND pt.id.pdm.zone.enforcementMode = de.rtb.pcon.model.zone.EnforcementMode.LPN\n  AND pt.paymentReason IN (:paymentReasons)\n  AND pt.lpn = :lpn\n  AND pt.id.pdmTime > :searchStart\nORDER BY parkEndTime DESC")
    public List<PaymentTransaction> findPermitsByLpn(@Param(value="zone") Zone var1, @Param(value="paymentReasons") Collection<PaymentReason> var2, @Param(value="lpn") String var3, @Param(value="searchStart") OffsetDateTime var4, Pageable var5);

    @Query(value="FROM #{#entityName} pt\nWHERE\n  pt.id.pdm.zone = :zone\n  AND pt.id.pdm.zone.enforcementMode = de.rtb.pcon.model.zone.EnforcementMode.PSN\n  AND pt.paymentReason IN (:paymentReasons)\n  AND pt.psn = :psn\n  AND pt.id.pdmTime > :searchStart\nORDER BY parkEndTime DESC")
    public List<PaymentTransaction> findPermistByPsn(@Param(value="zone") Zone var1, @Param(value="paymentReasons") Collection<PaymentReason> var2, @Param(value="psn") Integer var3, @Param(value="searchStart") OffsetDateTime var4, Pageable var5);

    @Query(value="FROM #{#entityName}\nWHERE\n  basePermit = :basePermit\n  AND paymentReason = de.rtb.pcon.model.PaymentReason.PERMIT_EXTENSION\n  AND id.pdmTime > :searchStart\nORDER BY id.pdmTime")
    public List<PaymentTransaction> listPermitExtensions(@Param(value="basePermit") PaymentTransaction var1, @Param(value="searchStart") OffsetDateTime var2);

    @Query(value="SELECT count(*)\nFROM #{#entityName}\nWHERE\n  id.pdmTime < :timeNow\n  AND id.pdmTime > :searchFrom\n  AND parkEndTime >= :timeNow\n  AND id.pdm.zone = :zone")
    public Integer countActivPermits(@Param(value="timeNow") OffsetDateTime var1, @Param(value="zone") Zone var2, @Param(value="searchFrom") OffsetDateTime var3);

    @Query(value="FROM #{#entityName}\nWHERE\n  id.pdmTime < :timeNow\n  AND id.pdmTime > :searchFrom\n  AND parkEndTime >= :timeNow\n  AND id.pdm.zone = :zone")
    public List<PaymentTransaction> listActive(@Param(value="timeNow") OffsetDateTime var1, @Param(value="zone") Zone var2, @Param(value="searchFrom") OffsetDateTime var3);
}

