/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.v1;

import de.rtb.pcon.api.enforcement.v1.EnforcementControllerV1;
import de.rtb.pcon.api.enforcement.v1.EnforcementServiceV1;
import de.rtb.pcon.api.enforcement.v1.dao.EnfLpnProposalDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfLpnProposalsXmlRootDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfPermitBasicDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfPermitDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfPermitValidatedDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfPermitValidity;
import de.rtb.pcon.api.enforcement.v1.dao.EnfZoneDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfZoneTreeXmlRootDao;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.I18nService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@Tag(name="RTB", description="RTB interface")
@RestController
@RequestMapping(path={"/api/enforcement/v1/"})
@PreAuthorize(value="hasRole('ROLE_ENFORCEMENT_VIEW')")
public class EnforcementControllerV1 {
    private SecureEntityLoaderService entityLoader;
    private I18nService i18n;
    private EnforcementServiceV1 enforcementService;

    public EnforcementControllerV1(SecureEntityLoaderService entityLoader, I18nService i18n, EnforcementServiceV1 enforcementService) {
        this.entityLoader = entityLoader;
        this.i18n = i18n;
        this.enforcementService = enforcementService;
    }

    @ExceptionHandler(value={EntityNotAvailableException.class})
    public ResponseEntity<String> handleEntityLoadException(EntityNotAvailableException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)ex.getHttpStatus());
    }

    @Operation(summary="List all zones in its areas available for enforcement.", description="This is a tree with areas and zones inside.")
    @GetMapping(path={"zones/tree"})
    @Transactional(readOnly=true)
    public EnfZoneTreeXmlRootDao zonesTreeXml() {
        return new EnfZoneTreeXmlRootDao(this.enforcementService.zoneTree());
    }

    @Operation(summary="Get zone by ID.")
    @Transactional(readOnly=true)
    @GetMapping(path={"zones/{id}"})
    public EnfZoneDao zone(@Parameter(description="Id of zone to read.", required=true) @PathVariable(value="id") int zoneId) {
        return new EnfZoneDao(this.entityLoader.loadZone(zoneId));
    }

    @Operation(summary="Permit detail for a Parking Space Number within a zone.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="Permit for such PSN does not exist.", content={@Content})})
    @GetMapping(path={"zones/{id}/permits/psn/{psn}"})
    @Transactional(readOnly=true)
    @Deprecated
    public ResponseEntity<EnfPermitValidatedDao> validatePsnPermit(@Parameter(description="Id of zone", required=true) @PathVariable(value="id") int zoneId, @Parameter(description="Parking Space Number", required=true) @PathVariable(value="psn") int psn, @Parameter(description="Tolerance in minutes in which the permit is still considered as valid after expiration.", required=false, example="0") @RequestParam(value="gracePeriod", defaultValue="0") int gracePeriodInMinutes, Authentication authentication) {
        boolean canViewLpn = UserRole.containsRole((Authentication)authentication, (UserRole)UserRole.ROLE_PCON_VIEW_LPN);
        Zone zone = this.entityLoader.loadZone(zoneId);
        Optional oPayment = this.enforcementService.validatePsn(zone, psn);
        return EnforcementControllerV1.paymentToPermitResponseEntity((Optional)oPayment, (Duration)Duration.ofMinutes(gracePeriodInMinutes), (ZoneId)this.i18n.userTimeZoneId(), (int)0, (boolean)canViewLpn);
    }

    @Operation(description="Permit detail for a License Plate Number within a zone.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="Permit for such LPN does not exist.", content={@Content})}, deprecated=true)
    @GetMapping(path={"zones/{id}/permits/lpn/{lpn}"})
    @Transactional(readOnly=true)
    @Deprecated
    public ResponseEntity<EnfPermitValidatedDao> validateLpnPermit(@Parameter(description="ID of zone.") @PathVariable(value="id") int zoneId, @Parameter(description="License Plate Number.") @PathVariable(value="lpn") String lpn, @Parameter(description="Tolerance in minutes in which the permit is still considered as valid after expiration.", required=false) @RequestParam(value="gracePeriod", defaultValue="0") int gracePeriodInMinutes, Authentication authentication) {
        boolean canViewLpn = UserRole.containsRole((Authentication)authentication, (UserRole)UserRole.ROLE_PCON_VIEW_LPN);
        Zone zone = this.entityLoader.loadZone(zoneId);
        Optional oPayment = this.enforcementService.validateLpn(zone, lpn);
        return EnforcementControllerV1.paymentToPermitResponseEntity((Optional)oPayment, (Duration)Duration.ofMinutes(gracePeriodInMinutes), (ZoneId)this.i18n.userTimeZoneId(), (int)0, (boolean)canViewLpn);
    }

    @Operation(summary="Permit detail for both License Plate Number and Parking Space Number within a zone.", description="This API call use either LPN or PSN validation based on zone settings. If zone is in PSN mode then the provided value must be convertible to integer.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="Permit for such LPN does not exist.", content={@Content}), @ApiResponse(responseCode="422", description="PSN is not convertible to integer", content={@Content})})
    @GetMapping(path={"zones/{id}/permits/{permit}"})
    @Transactional(readOnly=true)
    public ResponseEntity<EnfPermitValidatedDao> validatePermit(@Parameter(description="ID of zone.") @PathVariable(value="id") int zoneId, @Parameter(description="Permit id. Either LPN or PSN") @PathVariable(value="permit") String permit, @Parameter(description="Tolerance in minutes in which the permit is still considered as valid after expiration.", required=false) @RequestParam(value="gracePeriod", defaultValue="0") int gracePeriodInMinutes, @RequestParam(value="details", defaultValue="0") @Parameter(description="Controls how much details is provided in response. Values: 0 (less) 1 (more).", required=false, example="0") int detailLevel, Authentication authentication) {
        Optional optional;
        boolean canViewLpn = UserRole.containsRole((Authentication)authentication, (UserRole)UserRole.ROLE_PCON_VIEW_LPN);
        Zone zone = this.entityLoader.loadZone(zoneId);
        switch (1.$SwitchMap$de$rtb$pcon$model$zone$EnforcementMode[zone.getEnforcementMode().ordinal()]) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: {
                Optional optional2;
                optional = optional2 = this.enforcementService.validateLpn(zone, permit);
                break;
            }
            case 2: {
                Optional optional2;
                try {
                    optional = optional2 = this.enforcementService.validatePsn(zone, Integer.parseInt(permit));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
                }
            }
            case 3: {
                Optional optional2;
                optional = optional2 = Optional.empty();
            }
        }
        Optional oPayment = optional;
        return EnforcementControllerV1.paymentToPermitResponseEntity((Optional)oPayment, (Duration)Duration.ofMinutes(gracePeriodInMinutes), (ZoneId)this.i18n.userTimeZoneId(), (int)detailLevel, (boolean)canViewLpn);
    }

    private static ResponseEntity<EnfPermitValidatedDao> paymentToPermitResponseEntity(Optional<PaymentTransaction> oPayment, Duration gracePeriod, ZoneId timeZone, int detailLevel, boolean canViewLpn) {
        if (oPayment.isPresent()) {
            PaymentTransaction pt = oPayment.orElseThrow();
            Object uiValidationResult = detailLevel == 0 ? new EnfPermitValidatedDao(pt, timeZone, gracePeriod, canViewLpn) : new EnfPermitDao(pt, timeZone, gracePeriod, canViewLpn);
            return ResponseEntity.ok((Object)uiValidationResult);
        }
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Propose license plate numbers containing text from 'lpnPart' parameter within zone.")
    @GetMapping(path={"zones/{id}/permits/propose/lpns"})
    @Transactional(readOnly=true)
    public EnfLpnProposalsXmlRootDao proposeLpnPermitsXml(@Parameter(description="ID of zone", required=true) @PathVariable(value="id") int zoneId, @Parameter(description="Charters which the LPN has to contain") @RequestParam(value="lpnPart") String lpn, @Parameter(description="Tolerance in minutes in which the permit is still considered as valid after expiration.", required=false, example="0") @RequestParam(value="gracePeriod", defaultValue="0") int gracePeriodInMinutes, @Parameter(description="Maximal count of proposals in range [1-30]. Value 30 is also maximum.") @RequestParam(value="maxProposals", defaultValue="30") int maxProposalsUi) {
        if (StringUtils.isBlank((CharSequence)lpn)) {
            return new EnfLpnProposalsXmlRootDao(List.of());
        }
        Zone zone = this.entityLoader.loadZone(zoneId);
        int maxProposals = Math.min(30, maxProposalsUi);
        List validLpns = this.enforcementService.propseLpns(zone, lpn, maxProposals);
        Duration gracePeriod = Duration.ofMinutes(gracePeriodInMinutes);
        List proposals = validLpns.stream().map(p -> {
            Duration remainingTime = Duration.between(OffsetDateTime.now(), p.getParkEnd());
            EnfPermitValidity validity = EnfPermitValidatedDao.validate((Duration)remainingTime, (Duration)gracePeriod);
            return new EnfLpnProposalDao(p.getLpn(), validity, remainingTime);
        }).collect(Collectors.toList());
        return new EnfLpnProposalsXmlRootDao(proposals);
    }

    @Operation(summary="List active parking permits in Zone.")
    @GetMapping(value={"zones/{id}/permits/active"})
    @Transactional(readOnly=true)
    public List<EnfPermitBasicDao> listActivePermits(@PathVariable(value="id") Integer zoneId, @Parameter(description="How many days in history should be considered for searching parking start [0-30].") @RequestParam(value="history", defaultValue="7") Integer historyWindowInDays, @Parameter(description="Tolerance in minutes in which the permit is still considered as valid after expiration.", required=false, example="0") @RequestParam(value="gracePeriod", defaultValue="0") Integer gracePeriodInMunutes, Authentication authentication) {
        boolean canViewLpn = UserRole.containsRole((Authentication)authentication, (UserRole)UserRole.ROLE_PCON_VIEW_LPN);
        Zone zone = this.entityLoader.loadZone(zoneId.intValue());
        int historyWindow = Math.min(historyWindowInDays, 30);
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        return this.enforcementService.listActiveParkingSessions(zone, Duration.ofDays(historyWindow)).stream().map(p -> new EnfPermitValidatedDao(p, userTimeZone, Duration.ofMinutes(gracePeriodInMunutes.intValue()), canViewLpn)).collect(Collectors.toList());
    }
}

