/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.aims.service;

import com.google.common.collect.Sets;
import de.rtb.pcon.api.enforcement.aims.service.EnfPermit;
import de.rtb.pcon.api.enforcement.aims.service.EnfZone;
import de.rtb.pcon.api.enforcement.aims.service.EnforcementDao;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.zone.EnforcementMode;
import de.rtb.pcon.ui.services.SecurityService;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class EnforcementService {
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.EnforcementService");
    @Autowired
    @Qualifier(value="defaultEnforcementDao")
    private EnforcementDao dao;
    @Autowired
    private SecurityService securityService;

    public EnforcementService() {
    }

    public EnforcementService(EnforcementDao dao) {
        this.dao = dao;
    }

    public Set<EnfZone> listZones(int areaId) {
        return this.securityService.getCurrentAreas().stream().filter(a -> a.getId().equals(areaId)).findAny().map(Area::getZones).orElse(List.of()).stream().filter(z -> EnforcementMode.LPN.equals((Object)z.getEnforcementMode())).map(EnfZone::new).collect(Collectors.toSet());
    }

    public List<Integer> verifyZoneIdsLoosly(Integer areaId, Collection<Integer> zoneIds) {
        List<Integer> loadedZoneIds = this.listZones(areaId.intValue()).stream().map(EnfZone::getId).filter(zoneIds::contains).toList();
        Sets.SetView missingZones = Sets.difference(new HashSet<Integer>(zoneIds), new HashSet<Integer>(loadedZoneIds));
        String missingZoneIds = missingZones.stream().map(Objects::toString).collect(Collectors.joining(","));
        if (!missingZoneIds.isEmpty()) {
            String requestedZonesId = zoneIds.stream().map(Objects::toString).collect(Collectors.joining(","));
            String errorDescription = "Zones '" + missingZoneIds + "' was not found (requested: '" + requestedZonesId + "').";
            actionLogger.info(errorDescription);
        }
        return loadedZoneIds;
    }

    public Set<EnfPermit> validPermits(Collection<Integer> zoneIds, Collection<String> licensePlates, Duration gracePeriod) {
        return this.dao.validPermits(zoneIds, licensePlates, gracePeriod);
    }
}

