/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.aims.service;

import de.rtb.pcon.api.enforcement.aims.service.EnfPermit;
import de.rtb.pcon.api.enforcement.aims.service.EnfZone;
import de.rtb.pcon.api.enforcement.aims.service.EnforcementDao;
import de.rtb.pcon.core.services.pdm_in.MessageParserHelper;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransactionId;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.EnforcementMode;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcontrol.utils.DateTimeUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository(value="defaultEnforcementDao")
public class EnforcementDaoImpl
implements EnforcementDao {
    @PersistenceContext
    private EntityManager entityManager;

    public Optional<Set<EnfZone>> zones(int number, String apiKey) {
        try {
            Area a = (Area)this.entityManager.createQuery("FROM Area WHERE id = :number AND apiKey = :apiKey", Area.class).setParameter("number", (Object)number).setParameter("apiKey", (Object)apiKey).getSingleResult();
            List zones = this.entityManager.createQuery("FROM Zone WHERE area = :area AND enforcementMode = :enfLpn", Zone.class).setParameter("area", (Object)a).setParameter("enfLpn", (Object)EnforcementMode.LPN).getResultList();
            return Optional.of(zones.stream().map(EnfZone::new).collect(Collectors.toSet()));
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Set<EnfPermit> validPermits(Collection<Integer> zoneIds, Collection<String> licensePlates, Duration gracePeriod) {
        if (zoneIds.isEmpty()) {
            return Collections.emptySet();
        }
        Set normalizedLicensePlates = licensePlates.stream().map(MessageParserHelper::parseLcn).collect(Collectors.toSet());
        OffsetDateTime timeToCheck = DateTimeUtils.serverNowO();
        HashMap<String, Object> qParams = new HashMap<String, Object>();
        qParams.put("timeStart", timeToCheck);
        qParams.put("timeEnd", timeToCheck.minus(gracePeriod));
        qParams.put("enfModLpn", EnforcementMode.LPN.ordinal());
        qParams.put("zoneIds", zoneIds);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("WITH valid_permits AS ( SELECT lpn, payment.pdm_id, pay_ts, tracer, expiration_ts, zon_id, amount, currency, pdm_number, pdm_name, tai_name FROM %1$s.payment JOIN %1$s.pdm ON payment.pdm_id = pdm.pdm_id JOIN %1$s.zone ON pdm_zone_id = zon_id LEFT JOIN %1$s.tariff_info ON tai_id = tariff_info_id WHERE pay_ts <= :timeStart AND expiration_ts >= :timeEnd AND pay_reason in ('%2$s', '%3$s', '%4$s') AND zon_id in (:zoneIds) AND zon_enforcement = :enfModLpn".formatted("control", PaymentReason.PURCHASE.name(), PaymentReason.RTP_LOGON.name(), PaymentReason.RTP.name()));
        queryBuilder.append(" ");
        if (licensePlates.isEmpty()) {
            queryBuilder.append("AND lpn is not null and lpn != '' ");
        } else {
            queryBuilder.append("AND lpn in (:licensePlates) ");
            qParams.put("licensePlates", normalizedLicensePlates);
        }
        queryBuilder.append(") ");
        queryBuilder.append("SELECT * FROM (SELECT lpn, MAX(expiration_ts) as max_exp_time FROM valid_permits GROUP BY lpn) AS x JOIN valid_permits AS perms on perms.lpn = x.lpn AND expiration_ts = max_exp_time");
        Query query = this.entityManager.createNativeQuery(queryBuilder.toString());
        for (Map.Entry entry : qParams.entrySet()) {
            query.setParameter((String)entry.getKey(), entry.getValue());
        }
        List qResult = query.getResultList();
        LinkedHashSet<EnfPermit> permits = LinkedHashSet.newLinkedHashSet(qResult.size());
        for (Object[] r : qResult) {
            String lpn = (String)r[2];
            Integer pdmId = (Integer)r[3];
            Instant validFromTimeStamp = (Instant)r[4];
            Integer trc = (Integer)r[5];
            Instant validToTimeStamp = (Instant)r[6];
            Integer zoneId = (Integer)r[7];
            OffsetDateTime validFrom = OffsetDateTime.ofInstant(validFromTimeStamp, ZoneId.systemDefault());
            OffsetDateTime validTo = OffsetDateTime.ofInstant(validToTimeStamp, ZoneId.systemDefault());
            PaymentTransactionId payId = new PaymentTransactionId((Pdm)this.entityManager.getReference(Pdm.class, (Object)pdmId), validFrom, trc);
            Optional<EnfPermit> optPermit = permits.stream().filter(p -> p.getId().equals((Object)payId)).findAny();
            if (optPermit.isPresent()) {
                optPermit.get().getValidInZones().add(zoneId);
                continue;
            }
            EnfPermit p2 = new EnfPermit();
            p2.setId(payId);
            p2.setLicensePlate(lpn);
            p2.setValidFrom(validFrom);
            p2.setValidTo(validTo);
            p2.setValidInZones(new TreeSet());
            p2.setPrice((BigDecimal)r[8]);
            p2.setCurrency((String)r[9]);
            p2.setPdmNumber(((Integer)r[10]).intValue());
            p2.setPdmName((String)r[11]);
            p2.setTariffName((String)r[12]);
            p2.getValidInZones().add(zoneId);
            permits.add(p2);
        }
        return permits;
    }
}

