--liquibase formatted sql
--changeset ales.holec:250711T1012

-- Table for information about company operation on that area
CREATE TABLE control.area_company
(
    area_id integer NOT NULL,
    name character varying(200) NOT NULL DEFAULT '',
    contact character varying(1000) NOT NULL DEFAULT '',
    company_nr character varying(100) NOT NULL DEFAULT '',
    vat_nr character varying(100) NOT NULL DEFAULT '',
    vat_percent numeric(4, 2) NOT NULL DEFAULT 0,
    PRIMARY KEY (area_id),
    CONSTRAINT fk_area_company__area FOREIGN KEY (area_id) REFERENCES control.area (ac_id) ON UPDATE CASCADE ON DELETE CASCADE
);
COMMENT ON TABLE control.area_company IS 'Table for information about company operation on that area';
CREATE INDEX fki_area_company__area  ON control.area_company(area_id);

-- Insert missing area_company rows with default values
INSERT INTO control.area_company (area_id)
SELECT ac_id
FROM control.area
WHERE ac_id NOT IN (
    SELECT area_id FROM control.area_company
);
