--liquibase formatted sql
--changeset ales.holec:220912T1239 splitStatements:false

-- Rename column for area name.
ALTER TABLE IF EXISTS control.area RENAME ac_description TO ac_name;

-- Add collumn to store is thiz zone is default (where new PDMs will be added)
ALTER TABLE IF EXISTS control.zone ADD COLUMN zon_default boolean NOT NULL DEFAULT false;

-- Create new Zones and assign PDMs without zone to them.
DO
$$
DECLARE
	ar record;
	zone_id integer;
BEGIN
	-- Loop over areas which have PDMs without zone.
	FOR ar IN SELECT * FROM control.area WHERE (SELECT COUNT(*) FROM control.pdm WHERE pdm.pdm_area_id = area.ac_id AND pdm_zone_id IS NULL) > 0
	LOOP
		-- Insert new *default* Zone
		INSERT INTO control.zone (zon_name, zon_color, zon_area_id, zon_enforcement, zon_default) VALUES (ar.ac_name, '#f0f0f0', ar.ac_id, 0, true) RETURNING zon_id INTO zone_id;
		-- Assign PDMs without zone to this Zone.
		UPDATE control.pdm SET pdm_zone_id = zone_id WHERE pdm.pdm_zone_id IS NULL AND pdm_area_id = ar.ac_id AND pdm_zone_id IS NULL;
	END LOOP;
END;
$$;


-- Mark one of Zones defalut in Areas where multiple zones already exist.
DO
$$
DECLARE
	ar record;
	zone_id integer;
BEGIN
	-- Loop over areas which more than 1 zone and none of them is default.
	FOR ar IN
	SELECT *
	FROM control.area
	WHERE
		(SELECT COUNT(*) FROM control.zone WHERE zon_area_id = ac_id) > 1
		AND
		(SELECT COUNT(*) FROM control.zone WHERE zon_area_id = ac_id AND zon_default = true) = 0
	LOOP
		-- Find any zone to mark it as default.
		SELECT zon_id INTO zone_id FROM control.zone WHERE zon_area_id = ar.ac_id LIMIT 1;
		-- Set the zone default
		UPDATE control.zone SET zon_default = true WHERE zon_id = zone_id;
	END LOOP;
END;
$$;


-- Add default Zone to Areas where no default zone.
INSERT INTO control.zone (zon_name, zon_color, zon_area_id, zon_enforcement, zon_default)
SELECT ac_name, '#f0f0f0', ac_id, 0, true
FROM control.area
WHERE (SELECT count(*) FROM control.zone WHERE zon_area_id = ac_id AND zon_default = true) = 0;

-- Update constrants
ALTER TABLE IF EXISTS control.pdm DROP CONSTRAINT IF EXISTS fk_pdm__zone;
ALTER TABLE IF EXISTS control.pdm ADD CONSTRAINT fk_pdm__zone FOREIGN KEY (pdm_zone_id) REFERENCES control.zone (zon_id) MATCH SIMPLE ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE IF EXISTS control.pdm ALTER COLUMN pdm_zone_id SET NOT NULL;
-- Drop connectrion between PDM and area
ALTER TABLE control.pdm DROP COLUMN pdm_area_id;

-- Update ticket extension function
CREATE OR REPLACE FUNCTION control.extendible_permits(IN areanr integer,IN lpn character varying,IN psn integer)
    RETURNS TABLE(res_id bigint, res_base_price numeric, res_pay_date_time timestamp without time zone, res_exp_date_time timestamp without time zone, res_tariff_name character varying, res_base_permit_nr integer, res_pdm_number integer, res_pdm_name character varying, res_tolerance_time integer, res_peanlty_value numeric, res_parts integer, res_ext_price numeric, res_max_permits integer, res_max_duration integer, res_max_price numeric)
    LANGUAGE 'plpgsql'
    VOLATILE
    PARALLEL UNSAFE
    COST 100    ROWS 1000

AS $BODY$
DECLARE
  aTimeZone VARCHAR;
  historyLimit TIMESTAMP WITH TIME ZONE;
BEGIN
	SELECT ac_time_zone INTO aTimeZone FROM control.area WHERE ac_id = areaNr;
	EXECUTE 'SET LOCAL TIME ZONE ''' || aTimeZone || ''';' ;
	SELECT NOW() - INTERVAL '5 days' INTO historyLimit;

	RETURN QUERY
	WITH extension_candidates AS(
		SELECT
		tl_id AS id, tl_amount AS base_price, tl_pay_date_time::timestamp AS pay_time, tl_exp_date_time::timestamp AS exp_time, tai_name AS tariff_name, tl_ticket_no AS base_permit_nr, pdm_number AS seller_number, pdm_name AS seller_name,
		pex_tolerance_time AS tolerance_time, pex_peanlty_value AS peanlty_value,
		(SELECT COUNT (*)
		  FROM control.translog AS translog2
		  LEFT JOIN control.translog_ext ON translog_ext.permit_ext = translog2.tl_id
		  WHERE translog_ext.permit_base = translog.tl_id AND tl_pay_reason = 'PERMIT_EXTENSION'::control.payment_reason AND tl_pay_date_time > historyLimit
		)::integer AS ext_parts,
		(SELECT COALESCE (SUM (tl_amount), 0)
		  FROM control.translog AS translog2
		  LEFT JOIN control.translog_ext ON translog_ext.permit_ext = translog2.tl_id
		  WHERE control.translog_ext.permit_base = translog.tl_id AND tl_pay_reason = 'PERMIT_EXTENSION'::control.payment_reason AND tl_pay_date_time > historyLimit
		) AS ext_price,
		pex_max_permits AS max_permits, pex_max_duration AS max_duration, pex_max_price AS max_price
		FROM control.translog
			JOIN control.pdm on (tl_pdm_id = pdm_id)
			JOIN control.zone on (zon_id = pdm_zone_id)
			JOIN control.zone__perm_ext on pex_id = zon_id
			JOIN control.tariff_info on tai_id = tl_tariff_info_id
		WHERE
			pex_enabled
			AND tl_pay_date_time >  historyLimit
			AND tl_pay_reason = 'PURCHASE'::control.payment_reason
			AND zon_area_id = areaNr
			AND (
				((lpn IS NOT NULL) AND (tl_license_no = lpn))
				OR
				((psn IS NOT NULL) AND (tl_parking_space_no = psn))
			)
			AND (
				tl_exp_date_time > NOW()
				OR
				tl_exp_date_time > NOW() - CAST(GREATEST(pex_peanlty_time, pex_tolerance_time) || 'minutes' AS interval)
			)
		ORDER BY tl_exp_date_time DESC
	)
	SELECT DISTINCT ON (id) * FROM extension_candidates
	WHERE
		ext_parts < max_permits
		AND
		(base_price + ext_price) < max_price
		AND
		(EXTRACT(epoch FROM (exp_time - pay_time)) / 60) < max_duration
	LIMIT 10;
END;
$BODY$;
