--liquibase formatted sql
--changeset ales.holec:220317T1035

-- Status table: replace BTREE index by BRIN for time stamps.  
DROP INDEX control.idx_logbook__date_pdm;
CREATE INDEX idx_logbook__date_pdm ON control.logbook USING brin (log_date_pdm timestamptz_minmax_multi_ops);
DROP INDEX control.idx_logbook__date_pc;
CREATE INDEX idx_logbook__date_pc ON control.logbook USING brin (log_date_pc timestamptz_minmax_multi_ops);

-- Payment table: replace BTREE index by BRIN for time stamps.  
DROP INDEX control.idx_translog__pay_date_time;
CREATE INDEX idx_translog__pay_date_time ON control.translog USING brin (tl_pay_date_time timestamptz_minmax_multi_ops);

-- Clearing table: add BTREE index for timestamp.  
CREATE INDEX idx_clearing__clr_date_time ON control.clearing USING brin (clr_date_pdm timestamptz_minmax_multi_ops);
